/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.ITypeAggregate;
import org.eclipse.ptp.debug.core.aif.IValueAggregate;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.aif.ValueParent;

public abstract class ValueAggregate
extends ValueParent
implements IValueAggregate {
    protected List values = new ArrayList();

    public ValueAggregate(IValueParent parent, ITypeAggregate type, byte[] data) {
        super(parent, type);
        this.parse(data);
    }

    public int getChildrenNumber() throws AIFException {
        return this.values.size();
    }

    protected void parse(byte[] data) {
        ITypeAggregate typeAggregate = (ITypeAggregate)this.getType();
        int length = typeAggregate.getNumberOfChildren();
        int from = 0;
        int i = 0;
        while (i < length) {
            IAIFType aifType = typeAggregate.getType(i);
            byte[] newData = this.createByteArray(data, from, aifType.sizeof());
            IAIFValue val = AIFFactory.getAIFValue(this.getParent(), aifType, newData);
            this.values.add(val);
            from += val.sizeof();
            ++i;
        }
        this.size = from;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getString();
        }
        return this.result;
    }

    private String getString() throws AIFException {
        String content = "{";
        int length = this.values.size();
        int i = 0;
        while (i < length) {
            IAIFValue value = (IAIFValue)this.values.get(i);
            content = String.valueOf(content) + value.getValueString();
            if (i < length - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        return String.valueOf(content) + "}";
    }

    public IAIFValue getValue(int index) {
        return (IAIFValue)this.values.get(index);
    }
}

