/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.breakpoint;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.internal.core.breakpoint.PBreakpoint;

public abstract class AbstractLineBreakpoint
extends PBreakpoint
implements IPLineBreakpoint {
    public AbstractLineBreakpoint() {
    }

    public AbstractLineBreakpoint(IResource resource, String markerType, Map attributes, boolean add) throws CoreException {
        super(resource, markerType, attributes, add);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public String getAddress() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.address", "");
    }

    public String getFunction() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.function", "");
    }

    public void setAddress(String address) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.address", address);
    }

    public void setFunction(String function) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.function", function);
    }

    public String getFileName() throws CoreException {
        String fileName = this.getSourceHandle();
        Path path = new Path(fileName);
        return path.isValidPath(fileName) ? path.lastSegment() : null;
    }
}

