/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.model.IPType;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.AbstractPVariable;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PType;
import org.eclipse.ptp.debug.internal.core.model.PVariableFactory;

public class PIndexedValue
extends AbstractPValue
implements IIndexedValue {
    private IAIFValueArray fCDIValue;
    private IVariable[] fVariables;
    private int fOffset;
    private int fSize;
    private IPType fType;

    public PIndexedValue(AbstractPVariable parent, IAIFValueArray cdiValue, int offset, int size) {
        super(parent);
        this.fVariables = new IVariable[size];
        this.fCDIValue = cdiValue;
        this.fOffset = offset;
        this.fSize = size;
    }

    protected void setChanged(boolean changed) {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).setChanged(changed);
            }
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).dispose();
            }
            ++i;
        }
    }

    protected void reset() {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).resetValue();
            }
            ++i;
        }
    }

    protected void preserve() {
        this.resetStatus();
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).preserve();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPType getType() throws DebugException {
        if (this.fType == null) {
            PIndexedValue pIndexedValue = this;
            synchronized (pIndexedValue) {
                IAIF aif;
                if (this.fType == null && (aif = this.getAIF()) != null) {
                    this.fType = new PType(aif.getType());
                }
            }
        }
        return this.fType;
    }

    public String getReferenceTypeName() throws DebugException {
        IPType type = this.getType();
        return type != null ? type.getName() : "";
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.getVariables0(this.getInitialOffset(), this.getSize());
    }

    public boolean hasVariables() throws DebugException {
        return this.getSize() > 0;
    }

    public IVariable getVariable(int offset) throws DebugException {
        if (offset >= this.getSize()) {
            PIndexedValue.requestFailed(CoreModelMessages.getString("CIndexedValue.0"), null);
        }
        return this.getVariables0(offset, 1)[0];
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        if (offset >= this.getSize()) {
            PIndexedValue.requestFailed(CoreModelMessages.getString("CIndexedValue.1"), null);
        }
        if (offset + length - 1 >= this.getSize()) {
            PIndexedValue.requestFailed(CoreModelMessages.getString("CIndexedValue.2"), null);
        }
        return this.getVariables0(offset, length);
    }

    public int getSize() throws DebugException {
        return this.getSize0();
    }

    public int getInitialOffset() {
        return this.fOffset;
    }

    protected IAIFValueArray getCDIValue() {
        return this.fCDIValue;
    }

    private int getPartitionSize(int index) {
        int psize = this.getPreferredPartitionSize();
        int size = this.getSize0();
        int pcount = size / psize + 1;
        if (pcount - 1 < index) {
            return 0;
        }
        return pcount - 1 == index ? size % psize : psize;
    }

    private int getPartitionIndex(int offset) {
        return offset / this.getPreferredPartitionSize();
    }

    private int getPreferredPartitionSize() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IVariable[] getVariables0(int offset, int length) throws DebugException {
        IVariable[] result = new IVariable[length];
        int firstIndex = this.getPartitionIndex(offset);
        int lastIndex = this.getPartitionIndex(offset + Math.max(length - 1, 0));
        int i = firstIndex;
        while (i <= lastIndex) {
            PIndexedValue pIndexedValue = this;
            synchronized (pIndexedValue) {
                if (!this.isPartitionLoaded(i)) {
                    this.loadPartition(i);
                }
            }
            ++i;
        }
        System.arraycopy(this.fVariables, offset, result, 0, length);
        return result;
    }

    private boolean isPartitionLoaded(int index) {
        return this.fVariables[index * this.getPreferredPartitionSize()] != null;
    }

    private void loadPartition(int index) throws DebugException {
        int prefSize = this.getPreferredPartitionSize();
        int psize = this.getPartitionSize(index);
        IPCDIVariable[] cdiVars = new IPCDIVariable[]{};
        try {
            cdiVars = this.getParentVariable().getCDIVariable().getVariablesAsArray(index * prefSize, psize);
        }
        catch (PCDIException e) {
            PIndexedValue.requestFailed(e.getMessage(), null);
        }
        int i = 0;
        while (i < psize) {
            this.fVariables[i + index * prefSize] = PVariableFactory.createLocalVariable(this.getParentVariable(), cdiVars[i]);
            ++i;
        }
    }

    private int getSize0() {
        return this.fSize;
    }

    protected String processUnderlyingValue(IAIFValue aifValue) throws AIFException {
        return aifValue.getValueString();
    }
}

