/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignal;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDIAddressLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExpression;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariableDescriptor;
import org.eclipse.ptp.debug.core.model.IPGlobalVariable;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocator;
import org.eclipse.ptp.debug.internal.core.PGlobalVariableManager;
import org.eclipse.ptp.debug.internal.core.model.AbstractPVariable;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PExpression;
import org.eclipse.ptp.debug.internal.core.model.PThread;
import org.eclipse.ptp.debug.internal.core.model.PVariable;
import org.eclipse.ptp.debug.internal.core.model.PVariableFactory;

public class PStackFrame
extends PDebugElement
implements IPStackFrame,
IRestart,
IResumeWithoutSignal,
IPCDIEventListener {
    private IPCDIStackFrame fCDIStackFrame;
    private IPCDIStackFrame fLastCDIStackFrame;
    private PThread fThread;
    private List fVariables;
    private boolean fRefreshVariables = true;
    private List fExpressions;
    private boolean fIsDisposed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public PStackFrame(PThread thread, IPCDIStackFrame cdiFrame) {
        super((PDebugTarget)thread.getDebugTarget());
        this.setCDIStackFrame(cdiFrame);
        this.setThread(thread);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public IThread getThread() {
        return this.fThread;
    }

    public String getTargetID() {
        return String.valueOf(this.getCDITarget().getTargetID());
    }

    public IVariable[] getVariables() throws DebugException {
        IPGlobalVariable[] globals = this.getGlobals();
        List vars = this.getVariables0();
        ArrayList<IPGlobalVariable> all = new ArrayList<IPGlobalVariable>(globals.length + vars.size());
        all.addAll(Arrays.asList(globals));
        all.addAll(vars);
        return all.toArray(new IVariable[all.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        PThread thread = (PThread)this.getThread();
        if (thread.isSuspended()) {
            if (this.fVariables == null) {
                List vars = this.getAllCDIVariableObjects();
                this.fVariables = new ArrayList(vars.size());
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(PVariableFactory.createLocalVariable(this, (IPCDIVariableDescriptor)it.next()));
                }
            } else if (this.refreshVariables()) {
                this.updateVariables();
            }
            this.setRefreshVariables(false);
        }
        return this.fVariables != null ? this.fVariables : Collections.EMPTY_LIST;
    }

    protected void updateVariables() throws DebugException {
        List locals = this.getAllCDIVariableObjects();
        int index = 0;
        while (index < this.fVariables.size()) {
            IPCDIVariableDescriptor varObject = this.findVariable(locals, (PVariable)this.fVariables.get(index));
            if (varObject != null) {
                locals.remove(varObject);
                ++index;
                continue;
            }
            this.fVariables.remove(index);
        }
        Iterator newOnes = locals.iterator();
        while (newOnes.hasNext()) {
            this.fVariables.add(PVariableFactory.createLocalVariable(this, (IPCDIVariableDescriptor)newOnes.next()));
        }
    }

    protected IPCDIVariableDescriptor findVariable(List list, PVariable var) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            IPCDIVariableDescriptor newVarObject = (IPCDIVariableDescriptor)it.next();
            if (!var.sameVariable(newVarObject)) continue;
            return newVarObject;
        }
        return null;
    }

    protected void setThread(PThread thread) {
        this.fThread = thread;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables0().size() > 0;
    }

    public int getLineNumber() throws DebugException {
        PTPDebugCorePlugin.getDefault().getLogger().finer("");
        if (this.isSuspended()) {
            ISourceLocator locator = ((PDebugTarget)this.getDebugTarget()).getSourceLocator();
            if (locator != null && locator instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)locator;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iAdaptable.getAdapter((Class)clazz) != null) {
                    IAdaptable iAdaptable2 = (IAdaptable)locator;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((IPSourceLocator)iAdaptable2.getAdapter((Class)clazz2)).getLineNumber(this);
                }
            }
            if (this.getCDIStackFrame() != null && this.getCDIStackFrame().getLocator() != null) {
                return this.getCDIStackFrame().getLocator().getLineNumber();
            }
        }
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        IPCDILocator locator = this.getCDIStackFrame().getLocator();
        String func = "";
        String file = "";
        String line = "";
        if (locator.getFunction() != null && locator.getFunction().trim().length() > 0) {
            func = String.valueOf(func) + locator.getFunction() + "() ";
        }
        if (locator.getFile() != null && locator.getFile().trim().length() > 0) {
            file = locator.getFile();
            if (locator.getLineNumber() != 0) {
                line = NumberFormat.getInstance().format(new Integer(locator.getLineNumber()));
            }
        } else {
            return func;
        }
        return MessageFormat.format(CoreModelMessages.getString("CStackFrame.0"), func, file, line);
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.getThread().canStepInto();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.exists() && this.getThread().canStepOver();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            if (!this.exists()) {
                return false;
            }
            List frames = ((PThread)this.getThread()).computeStackFrames();
            if (frames != null && !frames.isEmpty()) {
                boolean bottomFrame = this.equals(frames.get(frames.size() - 1));
                return !bottomFrame && this.getThread().canStepReturn();
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.getThread().stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (this.canStepOver()) {
            this.getThread().stepOver();
        }
    }

    public void stepReturn() throws DebugException {
        if (this.canStepReturn()) {
            this.getThread().stepReturn();
        }
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        boolean exists = false;
        try {
            exists = this.exists();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return exists && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    protected IPCDIStackFrame getCDIStackFrame() {
        return this.fCDIStackFrame;
    }

    protected void setCDIStackFrame(IPCDIStackFrame frame) {
        this.fLastCDIStackFrame = frame != null ? frame : this.fCDIStackFrame;
        this.fCDIStackFrame = frame;
        this.setRefreshVariables(true);
    }

    protected IPCDIStackFrame getLastCDIStackFrame() {
        return this.fLastCDIStackFrame;
    }

    protected static boolean equalFrame(IPCDIStackFrame frameOne, IPCDIStackFrame frameTwo) {
        if (frameOne == null || frameTwo == null) {
            return false;
        }
        IPCDILocator loc1 = frameOne.getLocator();
        IPCDILocator loc2 = frameTwo.getLocator();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        if (loc1.getFile() != null && loc1.getFile().length() > 0 && loc2.getFile() != null && loc2.getFile().length() > 0 && loc1.getFile().equals(loc2.getFile()) && loc1.getFunction() != null && loc1.getFunction().length() > 0 && loc2.getFunction() != null && loc2.getFunction().length() > 0 && loc1.getFunction().equals(loc2.getFunction())) {
            return true;
        }
        if (!(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() == null || loc1.getFunction().length() <= 0 || loc2.getFunction() == null || loc2.getFunction().length() <= 0 || !loc1.getFunction().equals(loc2.getFunction()))) {
            return true;
        }
        return !(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() != null && loc1.getFunction().length() >= 1 || loc2.getFunction() != null && loc2.getFunction().length() >= 1 || loc1.getAddress() != loc2.getAddress());
    }

    protected boolean exists() throws DebugException {
        return ((PThread)this.getThread()).computeStackFrames().indexOf(this) != -1;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this;
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return this;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz4) {
            return this;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.eclipse.ptp.debug.internal.core.model.PStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz5) {
            return this;
        }
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("org.eclipse.ptp.debug.core.model.IPStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz6) {
            return this;
        }
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("org.eclipse.debug.core.model.IStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz7) {
            return this;
        }
        Class<?> clazz8 = class$8;
        if (clazz8 == null) {
            try {
                clazz8 = class$8 = Class.forName("org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz8) {
            return this.getCDIStackFrame();
        }
        Class<?> clazz9 = class$9;
        if (clazz9 == null) {
            try {
                clazz9 = class$9 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz9) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    protected void dispose() {
        this.setDisposed(true);
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeAllVariables();
        this.disposeExpressions();
    }

    protected void disposeAllVariables() {
        if (this.fVariables == null) {
            return;
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((PVariable)it.next()).dispose();
        }
        this.fVariables.clear();
        this.fVariables = null;
    }

    protected void disposeExpressions() {
        if (this.fExpressions != null) {
            Iterator it = this.fExpressions.iterator();
            while (it.hasNext()) {
                ((PExpression)it.next()).dispose();
            }
            this.fExpressions.clear();
        }
        this.fExpressions = null;
    }

    protected List getCDILocalVariableObjects() throws DebugException {
        ArrayList<IPCDILocalVariableDescriptor> list = new ArrayList<IPCDILocalVariableDescriptor>();
        try {
            list.addAll(Arrays.asList(this.getCDIStackFrame().getLocalVariableDescriptors()));
        }
        catch (PCDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected List getCDIArgumentObjects() throws DebugException {
        ArrayList<IPCDIArgumentDescriptor> list = new ArrayList<IPCDIArgumentDescriptor>();
        try {
            list.addAll(Arrays.asList(this.getCDIStackFrame().getArgumentDescriptors()));
        }
        catch (PCDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected List getAllCDIVariableObjects() throws DebugException {
        ArrayList list = new ArrayList();
        list.addAll(this.getCDIArgumentObjects());
        list.addAll(this.getCDILocalVariableObjects());
        return list;
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame tos = this.getThread().getTopStackFrame();
        return tos != null && tos.equals(this);
    }

    public IAddress getAddress() {
        IAddressFactory factory = ((PDebugTarget)this.getDebugTarget()).getAddressFactory();
        return factory.createAddress(this.getCDIStackFrame().getLocator().getAddress());
    }

    public String getFile() {
        return this.getCDIStackFrame().getLocator().getFile();
    }

    public String getFunction() {
        return this.getCDIStackFrame().getLocator().getFunction();
    }

    public int getLevel() {
        return this.getCDIStackFrame().getLevel();
    }

    public int getFrameLineNumber() {
        return this.getCDIStackFrame().getLocator().getLineNumber();
    }

    protected synchronized void preserve() {
        this.preserveVariables();
        this.preserveExpressions();
    }

    private void preserveVariables() {
        if (this.fVariables == null) {
            return;
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            AbstractPVariable av = (AbstractPVariable)it.next();
            av.preserve();
        }
    }

    private void preserveExpressions() {
        if (this.fExpressions == null) {
            return;
        }
        Iterator it = this.fExpressions.iterator();
        while (it.hasNext()) {
            PExpression exp = (PExpression)it.next();
            exp.preserve();
        }
    }

    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    private void setRefreshVariables(boolean refresh) {
        this.fRefreshVariables = refresh;
    }

    private boolean refreshVariables() {
        return this.fRefreshVariables;
    }

    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }

    private IPGlobalVariable[] getGlobals() {
        PGlobalVariableManager gvm = ((PDebugTarget)this.getDebugTarget()).getGlobalVariableManager();
        if (gvm != null) {
            return gvm.getGlobals();
        }
        return new IPGlobalVariable[0];
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (DebugException e) {
            return e.getLocalizedMessage();
        }
    }

    public String evaluateExpressionToString(String expression) throws DebugException {
        try {
            return this.getCDITarget().evaluateExpressionToString(this.getCDIStackFrame(), expression);
        }
        catch (PCDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    public boolean canEvaluate() {
        PDebugTarget target = (PDebugTarget)this.getDebugTarget();
        return target.supportsExpressionEvaluation() && target.isSuspended();
    }

    protected void doStepReturn() throws DebugException {
        try {
            this.getCDIStackFrame().stepReturn();
        }
        catch (PCDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
    }

    private synchronized PExpression getExpression(String expressionText) throws DebugException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList(5);
        }
        PExpression expression = null;
        Iterator it = this.fExpressions.iterator();
        while (it.hasNext()) {
            expression = (PExpression)it.next();
            if (expression.getExpressionText().compareTo(expressionText) != 0) continue;
            return expression;
        }
        try {
            IPCDIExpression cdiExpression = ((PDebugTarget)this.getDebugTarget()).getCDITarget().createExpression(expressionText);
            expression = new PExpression(this, cdiExpression, null);
            this.fExpressions.add(expression);
        }
        catch (PCDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return expression;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    private void setDisposed(boolean isDisposed) {
        this.fIsDisposed = isDisposed;
    }

    public boolean canRunToLine(IFile file, int lineNumber) {
        return this.getThread().canResume();
    }

    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(file, lineNumber)) {
            return;
        }
        this.runToLine(file.getLocation().lastSegment(), lineNumber, skipBreakpoints);
    }

    public boolean canRunToLine(String fileName, int lineNumber) {
        return this.getThread().canResume();
    }

    public void runToLine(String fileName, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(fileName, lineNumber)) {
            return;
        }
        if (skipBreakpoints) {
            ((PDebugTarget)this.getDebugTarget()).skipBreakpoints(true);
        }
        IPCDILineLocation location = this.getCDITarget().createLineLocation(fileName, lineNumber);
        try {
            this.getCDIThread().stepUntil(location);
        }
        catch (CDIException e) {
            if (skipBreakpoints) {
                ((PDebugTarget)this.getDebugTarget()).skipBreakpoints(false);
            }
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canRunToAddress(IAddress address) {
        return this.getThread().canResume();
    }

    public void runToAddress(IAddress address, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToAddress(address)) {
            return;
        }
        if (skipBreakpoints) {
            ((PDebugTarget)this.getDebugTarget()).skipBreakpoints(true);
        }
        IPCDIAddressLocation location = this.getCDITarget().createAddressLocation(new BigInteger(address.toString()));
        try {
            this.getCDIThread().stepUntil(location);
        }
        catch (CDIException e) {
            if (skipBreakpoints) {
                ((PDebugTarget)this.getDebugTarget()).skipBreakpoints(false);
            }
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canJumpToLine(IFile file, int lineNumber) {
        return this.getThread().canResume();
    }

    public void jumpToLine(IFile file, int lineNumber) throws DebugException {
        if (!this.canJumpToLine(file, lineNumber)) {
            return;
        }
        this.jumpToLine(file.getLocation().lastSegment(), lineNumber);
    }

    public boolean canJumpToLine(String fileName, int lineNumber) {
        return this.getThread().canResume();
    }

    public void jumpToLine(String fileName, int lineNumber) throws DebugException {
        if (!this.canJumpToLine(fileName, lineNumber)) {
            return;
        }
        IPCDILineLocation location = this.getCDITarget().createLineLocation(fileName, lineNumber);
        try {
            this.getCDIThread().resume(location);
        }
        catch (PCDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canJumpToAddress(IAddress address) {
        return this.getThread().canResume();
    }

    public void jumpToAddress(IAddress address) throws DebugException {
        if (!this.canJumpToAddress(address)) {
            return;
        }
        IPCDIAddressLocation location = this.getCDITarget().createAddressLocation(new BigInteger(address.toString()));
        try {
            this.getCDIThread().resume(location);
        }
        catch (PCDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    private IPCDIThread getCDIThread() {
        return ((PThread)this.getThread()).getCDIThread();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        PTPDebugCorePlugin.getDefault().getLogger().finer("");
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        PTPDebugCorePlugin.getDefault().getLogger().finer("");
        return false;
    }

    public IValue evaluateExpression(String expressionText) throws DebugException {
        PExpression expression;
        PTPDebugCorePlugin.getDefault().getLogger().finer("");
        if (!this.isDisposed() && (expression = this.getExpression(expressionText)) != null) {
            return expression.getValue(this);
        }
        return null;
    }

    public void handleDebugEvents(IPCDIEvent[] events) {
    }
}

