/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.aif.IAIFTypeRange;
import org.eclipse.ptp.debug.core.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.aif.IAIFTypeStruct;
import org.eclipse.ptp.debug.core.aif.ITypeIntegral;
import org.eclipse.ptp.debug.core.model.IPType;

public class PType
implements IPType {
    private IAIFType fAIFType;

    public PType(IAIFType cdiType) {
        this.setAIFType(cdiType);
    }

    public String getName() {
        return this.fAIFType != null ? this.fAIFType.toString() : null;
    }

    public void dispose() {
        this.fAIFType = null;
    }

    public int[] getArrayDimensions() {
        int[] dims = new int[]{};
        IAIFType type = this.getAIFType();
        if (type instanceof IAIFTypeArray) {
            dims = new int[((IAIFTypeArray)type).getDimension()];
            int i = 0;
            while (i < dims.length) {
                IAIFTypeRange range = ((IAIFTypeArray)type).getRange(i);
                dims[i] = range.getUpper() - range.getLower() + 1;
                ++i;
            }
        }
        return dims;
    }

    public boolean isArray() {
        return this.getAIFType() instanceof IAIFTypeArray;
    }

    public boolean isCharacter() {
        return this.getAIFType() instanceof IAIFTypeChar;
    }

    public boolean isFloatingPointType() {
        return this.getAIFType() instanceof IAIFTypeFloat;
    }

    public boolean isPointer() {
        return this.getAIFType() instanceof IAIFTypePointer;
    }

    public boolean isReference() {
        return this.getAIFType() instanceof IAIFTypeReference;
    }

    public boolean isStructure() {
        return this.getAIFType() instanceof IAIFTypeStruct;
    }

    public boolean isSigned() {
        return this.isIntegralType() ? false : ((ITypeIntegral)this.getAIFType()).isSigned();
    }

    public boolean isIntegralType() {
        return this.getAIFType() instanceof ITypeIntegral;
    }

    protected IAIFType getAIFType() {
        return this.fAIFType;
    }

    protected void setAIFType(IAIFType type) {
        this.fAIFType = type;
    }

    protected boolean isAggregate() {
        return this.isArray() || this.isStructure() || this.isPointer() || this.isReference();
    }
}

