/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueChar;
import org.eclipse.ptp.debug.core.aif.IAIFValueFloat;
import org.eclipse.ptp.debug.core.aif.IAIFValueInt;
import org.eclipse.ptp.debug.core.aif.IAIFValuePointer;
import org.eclipse.ptp.debug.core.aif.IAIFValueReference;
import org.eclipse.ptp.debug.core.aif.IAIFValueString;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPType;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.AbstractPVariable;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PType;
import org.eclipse.ptp.debug.internal.core.model.PVariable;
import org.eclipse.ptp.debug.internal.core.model.PVariableFactory;

public class PValue
extends AbstractPValue {
    private String fValueString = null;
    private List fVariables = Collections.EMPTY_LIST;
    private PType fType;

    protected PValue(PVariable parent) {
        super(parent);
    }

    protected PValue(PVariable parent, String message) {
        super(parent);
        this.setStatus(2, message);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getUnderlyingValue() != null) {
            boolean isSuspended;
            this.resetStatus();
            IPStackFrame cframe = this.getParentVariable().getStackFrame();
            boolean bl = isSuspended = cframe == null ? this.getCDITarget().isSuspended() : cframe.isSuspended();
            if (isSuspended) {
                try {
                    this.fValueString = this.processUnderlyingValue(this.getUnderlyingValue());
                }
                catch (AIFException e) {
                    this.setStatus(2, e.getMessage());
                }
            }
        }
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            try {
                List vars = this.getCDIVariables();
                this.fVariables = new ArrayList(vars.size());
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(PVariableFactory.createLocalVariable(this, (IPCDIVariable)it.next()));
                }
                this.resetStatus();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        try {
            IAIFValue value = this.getUnderlyingValue();
            if (value != null) {
                return value.getChildrenNumber() > 0;
            }
        }
        catch (AIFException e) {
            PValue.targetRequestFailed(e.getMessage(), null);
        }
        return false;
    }

    public IAIFValue getUnderlyingValue() throws DebugException {
        return this.getAIF().getValue();
    }

    protected List getCDIVariables() throws DebugException {
        IPCDIVariable[] vars = new IPCDIVariable[]{};
        try {
            vars = this.getParentVariable().getCDIVariable().getVariables();
        }
        catch (PCDIException e) {
            PValue.requestFailed(e.getMessage(), (Exception)((Object)e));
        }
        return Arrays.asList(vars);
    }

    protected synchronized void setChanged(boolean changed) {
        if (changed) {
            this.fValueString = null;
            this.resetStatus();
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).setChanged(changed);
        }
    }

    public void dispose() {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).dispose();
        }
    }

    protected String processUnderlyingValue(IAIFValue aifValue) throws AIFException {
        if (aifValue != null) {
            if (aifValue instanceof IAIFValueChar) {
                return this.getCharValueString((IAIFValueChar)aifValue);
            }
            if (aifValue instanceof IAIFValueInt) {
                return this.getIntValueString((IAIFValueInt)aifValue);
            }
            if (aifValue instanceof IAIFValueFloat) {
                return this.getFloatingPointValueString((IAIFValueFloat)aifValue);
            }
            if (aifValue instanceof IAIFValuePointer) {
                return this.getPointerValueString((IAIFValuePointer)aifValue);
            }
            if (aifValue instanceof IAIFValueReference) {
                return this.processUnderlyingValue(((IAIFValueReference)aifValue).getParent());
            }
            if (aifValue instanceof IAIFValueString) {
                return this.getWCharValueString((IAIFValueString)aifValue);
            }
            return aifValue.getValueString();
        }
        return null;
    }

    private String getCharValueString(IAIFValueChar value) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        char charValue = value.charValue();
        if (PVariableFormat.NATURAL.equals(format)) {
            return Character.isISOControl(charValue) && charValue != '\b' && charValue != '\t' && charValue != '\n' && charValue != '\f' && charValue != '\r' || charValue < '\u0000' ? "" : "'" + value.getValueString() + "'";
        }
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Integer.toString((byte)charValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Integer.toString((byte)charValue);
            sb.append(stringValue.length() > 2 ? stringValue.substring(stringValue.length() - 2) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getIntValueString(IAIFValueInt value) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        String stringValue = value.getValueString();
        if (PVariableFormat.NATURAL.equals(format) || PVariableFormat.DECIMAL.equals(format)) {
            return stringValue;
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            if (value.isShort()) {
                stringValue = Integer.toHexString(value.shortValue());
            } else if (value.isInt()) {
                stringValue = Integer.toHexString(value.intValue());
            } else if (value.isLong()) {
                stringValue = Long.toHexString(value.longValue());
            }
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getFloatingPointValueString(IAIFValueFloat value) throws AIFException {
        if (value.isDouble()) {
            return this.getDoubleValueString(value.getValueString());
        }
        if (value.isFloat()) {
            return this.getFloatValueString(value.getValueString());
        }
        return value.getValueString();
    }

    private String getFloatValueString(String floatValue) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format)) {
            return floatValue;
        }
        Float flt = new Float(floatValue);
        if (flt.isNaN() || flt.isInfinite()) {
            return "";
        }
        long longValue = flt.longValue();
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return floatValue;
    }

    private String getDoubleValueString(String doubleValue) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format)) {
            return doubleValue;
        }
        Double dbl = new Double(doubleValue);
        if (dbl.isNaN() || dbl.isInfinite()) {
            return "";
        }
        long longValue = dbl.longValue();
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
            return sb.toString();
        }
        return doubleValue;
    }

    private String getPointerValueString(IAIFValuePointer value) throws AIFException {
        IAddressFactory factory = ((PDebugTarget)this.getDebugTarget()).getAddressFactory();
        BigInteger pv = value.pointerValue();
        if (pv == null) {
            return "";
        }
        IAddress address = factory.createAddress(pv);
        if (address == null) {
            return "";
        }
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format) || PVariableFormat.HEXADECIMAL.equals(format)) {
            return address.toHexAddressString();
        }
        if (PVariableFormat.DECIMAL.equals(format)) {
            return address.toString();
        }
        return null;
    }

    private String getWCharValueString(IAIFValueString value) throws AIFException {
        return value.getValueString();
    }

    protected void reset() {
        this.resetStatus();
        this.fValueString = null;
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).resetValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPType getType() throws DebugException {
        IAIFValue cdiValue = this.getUnderlyingValue();
        if (this.fType == null && cdiValue != null) {
            PValue pValue = this;
            synchronized (pValue) {
                if (this.fType == null) {
                    this.fType = new PType(cdiValue.getType());
                }
            }
        }
        return this.fType;
    }

    protected void preserve() {
        this.setChanged(false);
        this.resetStatus();
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).preserve();
        }
    }
}

