/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;

public abstract class AbstractParallelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String HYPHEN = "-";
    public static final String NUM_PROC = "-p";
    public static final String PROC_PER_NODE = "-N";
    public static final String START_NODE = "-o";
    public static final String PROG_NAME = "--";

    protected IModelManager getLaunchManager() {
        return PTPCorePlugin.getDefault().getModelManager();
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProject getProject(String proName) {
        return this.getWorkspaceRoot().getProject(proName);
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String proName = AbstractParallelLaunchConfigurationDelegate.getProjectName(configuration);
        if (proName == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Project_not_specified"), null, 1);
        }
        if ((project = this.getProject(proName)) == null || !project.exists() || !project.isOpen()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Project_does_not_exist_or_is_not_a_project"), null, 1);
        }
        return project;
    }

    protected IFile getProgramFile(ILaunchConfiguration configuration) throws CoreException {
        IFile programPath;
        IProject project = this.verifyProject(configuration);
        String fileName = AbstractParallelLaunchConfigurationDelegate.getProgramName(configuration);
        if (fileName == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Application_file_not_specified"), null, 1);
        }
        if ((programPath = project.getFile(fileName)) == null || !programPath.exists() || !programPath.getLocation().toFile().exists()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Application_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Application_path_not_found", programPath.getLocation().toString())), 1);
        }
        return programPath;
    }

    protected IPath verifyProgramFile(ILaunchConfiguration configuration) throws CoreException {
        return this.getProgramFile(configuration).getLocation();
    }

    protected String[] getProgramParameters(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> arguments = new ArrayList<String>();
        String temp = AbstractParallelLaunchConfigurationDelegate.getArgument(configuration);
        if (temp != null && temp.length() > 0) {
            arguments.add(temp);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected JobRunConfiguration getJobRunConfiguration(ILaunchConfiguration configuration) throws CoreException {
        IFile programFile = this.getProgramFile(configuration);
        String nprocs_str = AbstractParallelLaunchConfigurationDelegate.getNumberOfProcesses(configuration);
        String nprocpnode_str = AbstractParallelLaunchConfigurationDelegate.getNumberOfProcessesPerNode(configuration);
        String firstnode_str = AbstractParallelLaunchConfigurationDelegate.getFirstNodeNumber(configuration);
        String machineName = AbstractParallelLaunchConfigurationDelegate.getMachineName(configuration);
        String[] args = this.getProgramParameters(configuration);
        String[] env = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        String dir = this.verifyWorkDirectory(configuration);
        int nprocs = -1;
        int nprocpnode = -1;
        int firstnode = -1;
        try {
            nprocs = new Integer(nprocs_str);
            nprocpnode = new Integer(nprocpnode_str);
            firstnode = new Integer(firstnode_str);
        }
        catch (NumberFormatException numberFormatException) {}
        return new JobRunConfiguration(programFile.getProjectRelativePath().toOSString(), dir, machineName, nprocs, nprocpnode, firstnode, args, env, dir);
    }

    protected String verifyWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        String workPath = AbstractParallelLaunchConfigurationDelegate.getWorkDirectory(configuration);
        if (workPath == null) {
            IProject project = this.verifyProject(configuration);
            if (project != null) {
                return project.getLocation().toOSString();
            }
        } else {
            Path path = new Path(workPath);
            if (path.isAbsolute()) {
                File dir = new File(path.toOSString());
                if (dir.isDirectory()) {
                    return path.toOSString();
                }
                this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Application_path_not_found", path.toOSString())), 1);
            } else {
                IResource res = this.getWorkspaceRoot().findMember((IPath)path);
                if (res instanceof IContainer && res.exists()) {
                    return res.getLocation().toOSString();
                }
                this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Application_path_not_found", path.toOSString())), 1);
            }
        }
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), code, message, exception));
    }

    protected static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
    }

    protected static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", null);
    }

    protected static String getMachineName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.MACHINE_NAME", null);
    }

    protected static String getNumberOfProcesses(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES", null);
    }

    protected static String getNumberOfProcessesPerNode(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES_START", null);
    }

    protected static String getFirstNodeNumber(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.NODE_NUMBER", null);
    }

    protected static String getArgument(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", null);
    }

    protected static String getWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
    }

    protected static String getDebuggerID(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", null);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PLaunch(configuration, mode, null);
    }
}

