/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class PTPLaunchShortcut
implements ILaunchShortcut {
    public static final String LauncherGroupID = "org.eclipse.debug.ui.launchGroup.run";
    static /* synthetic */ Class class$0;

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject element = (IProject)input.getAdapter((Class)clazz);
        this.launch(element, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).getFirstElement(), mode);
        }
    }

    public void launch(Object element, String mode) {
        if (!(element instanceof IFile)) {
            MessageDialog.openInformation((Shell)PTPLaunchPlugin.getActiveWorkbenchShell(), (String)"Incorrect file", (String)"Please select parallel program file");
            return;
        }
        IFile file = (IFile)element;
        ILaunchConfiguration config = this.getILaunchConfigure(file);
        StructuredSelection selection = null;
        selection = config == null ? new StructuredSelection() : new StructuredSelection((Object)config);
        ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PTPDebugUIPlugin.getShell(), (IStructuredSelection)selection, (String)group.getIdentifier());
    }

    public ILaunchConfiguration getILaunchConfigure(IFile file) {
        String projectName = file.getProject().getName();
        ILaunchManager lm = this.getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.eclipse.ptp.launch.parallelLaunch");
        try {
            ILaunchConfiguration[] configs = lm.getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                if (configs[i].getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", "").equals(projectName)) {
                    return configs[i];
                }
                ++i;
            }
            ILaunchConfigurationWorkingCopy wc = configType.newInstance((IContainer)file.getProject(), projectName);
            wc.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", projectName);
            wc.setAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", file.getName());
            wc.setAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES", "0");
            wc.setAttribute("org.eclipse.ptp.launch.NUMBER_OF_PROCESSES_START", "1");
            wc.setAttribute("org.eclipse.ptp.launch.NODE_NUMBER", "0");
            return wc.doSave();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

