/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.internal.AbstractParallelLaunchConfigurationDelegate;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;

public class ParallelLaunchConfigurationDelegate
extends AbstractParallelLaunchConfigurationDelegate {
    private IBinaryParser.IBinaryObject verifyBinary(IProject project, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return exe;
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        FileNotFoundException exception = new FileNotFoundException(LaunchMessages.getResourceString("AbstractParallelLaunchDelegate.Program_is_not_a_recongnized_executable"));
        int code = 107;
        MultiStatus status = new MultiStatus(PTPCorePlugin.getUniqueIdentifier(), code, LaunchMessages.getResourceString("AbstractParallelLaunchDelegate.Program_is_not_a_recongnized_executable"), (Throwable)exception);
        status.add((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), code, exception == null ? "" : exception.getLocalizedMessage(), (Throwable)exception));
        throw new CoreException((IStatus)status);
    }

    private static IPath getProgramPath(ILaunchConfiguration configuration) throws CoreException {
        String path = ParallelLaunchConfigurationDelegate.getProgramName(configuration);
        if (path == null) {
            return null;
        }
        return new Path(path);
    }

    private IPath verifyProgramPath(ILaunchConfiguration config) throws CoreException {
        IProject project = this.verifyProject(config);
        IPath programPath = ParallelLaunchConfigurationDelegate.getProgramPath(config);
        if (programPath == null || programPath.isEmpty()) {
            return null;
        }
        if (!programPath.isAbsolute()) {
            programPath = project.getFile(programPath).getLocation();
        }
        if (!programPath.toFile().exists()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getResourceString("AbstractParallelLaunchDelegate.PROGRAM_PATH_not_found")), 104);
        }
        return programPath;
    }

    public static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = ParallelLaunchConfigurationDelegate.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    private IPDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        IPDebugConfiguration dbgCfg = null;
        try {
            dbgCfg = PTPDebugCorePlugin.getDefault().getDebugConfiguration(ParallelLaunchConfigurationDelegate.getDebuggerID(config));
        }
        catch (CoreException e) {
            System.out.println("ParallelLaunchConfigurationDelegate.getDebugConfig() Error");
            throw e;
        }
        return dbgCfg;
    }

    private void verifyDebuggerPath(String path) throws CoreException {
        Path programPath = new Path(path);
        if (programPath == null || programPath.isEmpty() || !programPath.toFile().exists()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchDelegate.Debugger_path_not_found"), new FileNotFoundException(LaunchMessages.getResourceString("AbstractParallelLaunchDelegate.Debugger_path_not_found")), 104);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IBinaryParser.IBinaryObject exeFile = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 250);
        monitor.setTaskName(MessageFormat.format("{0} . . .", "Launching " + configuration.getName()));
        if (monitor.isCanceled()) {
            return;
        }
        PTPCorePlugin.getDefault().getModelManager().refreshRuntimeSystems((IProgressMonitor)new SubProgressMonitor(monitor, 50), false);
        IAbstractDebugger debugger = null;
        IPJob job = null;
        try {
            try {
                JobRunConfiguration jrunconfig = this.getJobRunConfiguration(configuration);
                IPath exePath = this.verifyProgramPath(configuration);
                IProject project = this.verifyProject(configuration);
                if (exePath != null) {
                    exeFile = this.verifyBinary(project, exePath);
                }
                IPreferenceStore store = PTPDebugUIPlugin.getDefault().getPreferenceStore();
                if (mode.equals("debug")) {
                    monitor.subTask("Configuring debug setting . . .");
                    String dbgFile = store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_FILE);
                    String dbgArgs = "--host=" + store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_HOST);
                    dbgArgs = String.valueOf(dbgArgs) + " --debugger=" + store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND);
                    String dbgPath = store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND_PATH);
                    if (dbgPath.length() > 0) {
                        dbgArgs = String.valueOf(dbgArgs) + " --debugger_path=" + dbgPath;
                    }
                    this.verifyDebuggerPath(dbgFile);
                    IPDebugConfiguration debugConfig = this.getDebugConfig(configuration);
                    debugger = debugConfig.createDebugger();
                    jrunconfig.setDebuggerPath(dbgFile);
                    dbgArgs = String.valueOf(dbgArgs) + " --port=" + debugger.getDebuggerPort();
                    jrunconfig.setDebuggerArgs(dbgArgs);
                    jrunconfig.setDebug();
                }
                monitor.worked(10);
                monitor.subTask("Starting the job . . .");
                job = this.getLaunchManager().run(launch, jrunconfig, (IProgressMonitor)new SubProgressMonitor(monitor, 150));
                if (mode.equals("debug")) {
                    monitor.setTaskName("Starting the debugger . . .");
                    job.setAttribute("app_name", (Object)jrunconfig.getExecName());
                    job.setAttribute("app_path", (Object)jrunconfig.getPathToExec());
                    job.setAttribute("work_dir", (Object)jrunconfig.getWorkingDir());
                    job.setAttribute("args", (Object)jrunconfig.getArguments());
                    job.setAttribute("debug_dir", (Object)exePath.removeLastSegments(1).toOSString());
                    PLaunch pLaunch = (PLaunch)launch;
                    pLaunch.setPJob(job);
                    int timeout = store.getInt(IPDebugConstants.PREF_PTP_DEBUG_COMM_TIMEOUT);
                    PTPDebugCorePlugin.getDebugModel().createDebuggerSession(debugger, (IPLaunch)pLaunch, exeFile, timeout, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                    monitor.worked(10);
                    if (monitor.isCanceled()) {
                        PTPDebugCorePlugin.getDebugModel().shutdownSession(job);
                    }
                } else {
                    monitor.worked(40);
                }
            }
            catch (CoreException e) {
                if (mode.equals("debug")) {
                    PTPDebugCorePlugin.getDebugModel().shutdownSession(job);
                    if (debugger != null) {
                        debugger.stopDebugger();
                    }
                }
                if (e.getStatus().getCode() != 8) {
                    throw e;
                }
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var16_20 = null;
        }
        monitor.done();
    }
}

