/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class LaunchUtils {
    public static final String ParallelProcessesView_ID = "org.eclipse.ptp.ui.views.parallelProcessesView";
    public static final String PPerspectiveFactory_ID = "org.eclipse.ptp.ui.PRunPerspective";
    public static final String ParallelProcessViewer_ID = "org.eclipse.ptp.ui.views.parallelProcessViewer";
    public static final String ParallelNodeStatusView_ID = "org.eclipse.ptp.ui.views.parallelNodeStatusView";
    public static final String ParallelJobsView_ID = "org.eclipse.ptp.ui.views.parallelJobsView";
    public static final String ParallelProcessStatusView_ID = "org.ecliipse.ptd.ui.views.parallelProcessStatusView";
    public static final String PTP_ACTION_SET = "org.eclipse.ptp.actionSets";
    public static final String PTP_SEARCHPAGE_ID = "org.eclipse.ptp.ui.PSearchPage";
    public static final int NORMAL = 0;
    public static final int ASYNC = 1;

    protected static void showDialog(Shell shell, String title, String message, int style) {
        MessageBox dialog = new MessageBox(shell, style);
        dialog.setMessage(message);
        dialog.setText(title);
        dialog.open();
    }

    protected static void showDialogAsync(final Shell shell, final String title, final String message, final int style) {
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                LaunchUtils.showDialog(shell, title, message, style);
            }
        });
    }

    public static void showWarningDialog(Shell shell, String title, String message, int flag) {
        if (flag == 0) {
            LaunchUtils.showDialog(shell, title, message, 40);
        } else {
            LaunchUtils.showDialogAsync(shell, title, message, 40);
        }
    }

    public static void showInformationDialog(Shell shell, String title, String message, int flag) {
        if (flag == 0) {
            LaunchUtils.showDialog(shell, title, message, 34);
        } else {
            LaunchUtils.showDialogAsync(shell, title, message, 34);
        }
    }

    public static void showErrorDialog(Shell shell, String title, String message, int flag) {
        if (flag == 0) {
            LaunchUtils.showDialog(shell, title, message, 33);
        } else {
            LaunchUtils.showDialogAsync(shell, title, message, 33);
        }
    }

    public static void showDetailErrorDialog(final Shell shell, final String title, final String message, final IStatus status) {
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
            }
        });
    }

    public static void showErrorDialog(final String title, final String message, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (status == null) {
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                } else {
                    ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
                }
            }
        });
    }

    public static boolean showQuestionDialog(String title, String message) {
        Shell shell = Display.getDefault().getActiveShell();
        return MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
    }

    public static void showView(final String viewID) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(this, viewID){
                    final /* synthetic */ 4 this$1;
                    private final /* synthetic */ String val$viewID;
                    {
                        this.this$1 = var1_1;
                        this.val$viewID = string;
                    }

                    public void run() {
                        try {
                            LaunchUtils.displayView(this.val$viewID);
                        }
                        catch (NullPointerException e) {
                            System.out.println("Show View err: " + e.getMessage());
                        }
                    }
                });
            }
        });
    }

    public static void switchPerspectiveTo(final String perspectiveID) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = LaunchUtils.getActivePage();
                if (page.getPerspective().getId().equals(perspectiveID)) {
                    return;
                }
                IWorkbench bench = PTPLaunchPlugin.getDefault().getWorkbench();
                try {
                    bench.showPerspective(perspectiveID, PTPLaunchPlugin.getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    LaunchUtils.showErrorDialog("Display Error", "Cannot switch Perspective to: " + perspectiveID, e.getStatus());
                }
            }
        });
    }

    public static IWorkbenchPage getActivePage() {
        return PTPLaunchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void displayView(String viewID) throws NullPointerException {
        IWorkbenchPage page = LaunchUtils.getActivePage();
        try {
            page.showView(viewID);
        }
        catch (PartInitException e) {
            LaunchUtils.showErrorDialog("Display Error", "Cannot show View ID: " + viewID, e.getStatus());
        }
    }

    public static IViewPart findView(String viewID) {
        IWorkbenchPage page = LaunchUtils.getActivePage();
        return page.findView(viewID);
    }

    public static void closeView(String viewID) {
        IViewPart viewPart = LaunchUtils.findView(viewID);
        if (viewPart == null) {
            return;
        }
        viewPart.dispose();
    }
}

