/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.launch.internal.ui.AbstractPDebuggerTab;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PDebuggerTab
extends AbstractPDebuggerTab {
    protected final boolean fAttachMode;
    protected Button fAdvancedButton;
    protected Button fStopInMain;
    protected Button fAttachButton;
    private Map fAdvancedAttributes = new HashMap(5);

    public PDebuggerTab(boolean attachMode) {
        this.fAttachMode = attachMode;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, true);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1, 2, true, false);
        comp.setLayoutData((Object)gd);
        this.createDebuggerCombo(comp, this.fAttachMode ? 1 : 2);
        this.createOptionsComposite(comp);
        this.createDebuggerGroup(comp, 2);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        String configPlatform = this.getPlatform(config);
        IPDebugConfiguration[] debugConfigs = PTPDebugCorePlugin.getDefault().getDebugConfigurations();
        Arrays.sort(debugConfigs, new Comparator(){

            public int compare(Object o1, Object o2) {
                IPDebugConfiguration ic1 = (IPDebugConfiguration)o1;
                IPDebugConfiguration ic2 = (IPDebugConfiguration)o2;
                return ic1.getName().compareTo(ic2.getName());
            }
        });
        ArrayList<IPDebugConfiguration> list = new ArrayList<IPDebugConfiguration>();
        String mode = this.fAttachMode ? "attach" : "run";
        String defaultSelection = selection;
        int i = 0;
        while (i < debugConfigs.length) {
            if (debugConfigs[i].supportsMode(mode)) {
                String debuggerPlatform = debugConfigs[i].getPlatform();
                if (this.validatePlatform(config, debugConfigs[i])) {
                    list.add(debugConfigs[i]);
                    if (defaultSelection.equals("") && debuggerPlatform.equalsIgnoreCase(configPlatform)) {
                        defaultSelection = debugConfigs[i].getID();
                    }
                }
            }
            ++i;
        }
        this.setInitializeDefault(selection.equals(""));
        this.loadDebuggerCombo(list.toArray(new IPDebugConfiguration[list.size()]), defaultSelection);
    }

    protected void updateComboFromSelection() {
        super.updateComboFromSelection();
        this.initializeCommonControls(this.getLaunchConfiguration());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        if (this.fAttachMode) {
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "run");
            config.setAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", true);
        }
        config.setAttribute("org.eclipse.ptp.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        config.setAttribute("org.eclipse.ptp.launch.ENABLE_REGISTER_BOOKKEEPING", false);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setInitializing(true);
        super.initializeFrom(config);
        try {
            String id = config.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox(config, id);
            this.initializeCommonControls(config);
        }
        catch (CoreException coreException) {}
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        if (this.fAttachMode) {
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", this.fStopInMain.getSelection());
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_START_MODE", "run");
        }
        this.applyAdvancedAttributes(config);
    }

    public boolean isValid(ILaunchConfiguration config) {
        String mode;
        if (!this.validateDebuggerConfig(config)) {
            return false;
        }
        IPDebugConfiguration debugConfig = this.getDebugConfig();
        String string = mode = this.fAttachMode ? "attach" : "run";
        if (!debugConfig.supportsMode(mode)) {
            this.setErrorMessage(MessageFormat.format(LaunchMessages.getResourceString("PDebuggerTab.Mode_not_supported"), mode));
            return false;
        }
        return super.isValid(config);
    }

    protected boolean validatePlatform(ILaunchConfiguration config, IPDebugConfiguration debugConfig) {
        String configPlatform = this.getPlatform(config);
        String debuggerPlatform = debugConfig.getPlatform();
        return debuggerPlatform.equals("*") || debuggerPlatform.equalsIgnoreCase(configPlatform);
    }

    protected boolean validateCPU(ILaunchConfiguration config, IPDebugConfiguration debugConfig) {
        IBinaryParser.IBinaryObject binaryFile = null;
        try {
            binaryFile = this.getBinary(config);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getLocalizedMessage());
        }
        String projectCPU = "native";
        if (binaryFile != null) {
            projectCPU = binaryFile.getCPU();
        }
        return debugConfig.supportsCPU(projectCPU);
    }

    protected IBinaryParser.IBinaryObject getBinary(ILaunchConfiguration config) throws CoreException {
        String programName = null;
        String projectName = null;
        try {
            projectName = config.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", "");
            programName = config.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", "");
        }
        catch (CoreException coreException) {}
        Path exePath = new Path(programName);
        if (projectName != null && !projectName.equals("")) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!exePath.isAbsolute()) {
                exePath = project.getFile((IPath)exePath).getLocation();
            }
            ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
            int i = 0;
            while (i < parserRef.length) {
                try {
                    IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                    IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary((IPath)exePath);
                    if (exe != null) {
                        return exe;
                    }
                }
                catch (ClassCastException classCastException) {
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return (IBinaryParser.IBinaryObject)parser.getBinary((IPath)exePath);
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    protected boolean validateDebuggerConfig(ILaunchConfiguration config) {
        IPDebugConfiguration debugConfig = this.getDebugConfig();
        if (debugConfig == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("PDebuggerTab.No_debugger_available"));
            return false;
        }
        if (!this.validatePlatform(config, debugConfig)) {
            this.setErrorMessage(LaunchMessages.getResourceString("PDebuggerTab.Platform_is_not_supported"));
            return false;
        }
        if (!this.validateCPU(config, debugConfig)) {
            this.setErrorMessage(LaunchMessages.getResourceString("PDebuggerTab.CPU_is_not_supported"));
            return false;
        }
        return true;
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected void createOptionsComposite(Composite parent) {
        GridLayout layout;
        Composite optionsComp = new Composite(parent, 0);
        if (this.fAttachMode) {
            layout = new GridLayout(1, false);
            optionsComp.setLayout((Layout)layout);
            optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        } else {
            layout = new GridLayout(2, false);
            optionsComp.setLayout((Layout)layout);
            optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
            this.fStopInMain = this.createCheckButton(optionsComp, LaunchMessages.getResourceString("PDebuggerTab.Stop_at_main_on_startup"));
            GridData data = new GridData();
            data.horizontalAlignment = 1;
            this.fStopInMain.setLayoutData((Object)data);
            this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!PDebuggerTab.this.isInitializing()) {
                        PDebuggerTab.this.updateLaunchConfigurationDialog();
                    }
                }
            });
        }
        this.fAdvancedButton = this.createPushButton(optionsComp, LaunchMessages.getResourceString("PDebuggerTab.Advanced"), null);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.fAdvancedButton.setLayoutData((Object)data);
        this.fAdvancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedDebuggerOptionsDialog dialog = new AdvancedDebuggerOptionsDialog(PDebuggerTab.this.getShell());
                dialog.open();
            }
        });
    }

    protected Map getAdvancedAttributes() {
        return this.fAdvancedAttributes;
    }

    private void initializeAdvancedAttributes(ILaunchConfiguration config) {
        Map attr = this.getAdvancedAttributes();
        try {
            Boolean varBookkeeping = config.getAttribute("org.eclipse.ptp.launch.ENABLE_VARIABLE_BOOKKEEPING", false) ? Boolean.TRUE : Boolean.FALSE;
            attr.put("org.eclipse.ptp.launch.ENABLE_VARIABLE_BOOKKEEPING", varBookkeeping);
        }
        catch (CoreException coreException) {}
        try {
            Boolean regBookkeeping = config.getAttribute("org.eclipse.ptp.launch.ENABLE_REGISTER_BOOKKEEPING", false) ? Boolean.TRUE : Boolean.FALSE;
            attr.put("org.eclipse.ptp.launch.ENABLE_REGISTER_BOOKKEEPING", regBookkeeping);
        }
        catch (CoreException coreException) {}
    }

    private void applyAdvancedAttributes(ILaunchConfigurationWorkingCopy config) {
        Object regBookkeeping;
        Map attr = this.getAdvancedAttributes();
        Object varBookkeeping = attr.get("org.eclipse.ptp.launch.ENABLE_VARIABLE_BOOKKEEPING");
        if (varBookkeeping instanceof Boolean) {
            config.setAttribute("org.eclipse.ptp.launch.ENABLE_VARIABLE_BOOKKEEPING", ((Boolean)varBookkeeping).booleanValue());
        }
        if ((regBookkeeping = attr.get("org.eclipse.ptp.launch.ENABLE_REGISTER_BOOKKEEPING")) instanceof Boolean) {
            config.setAttribute("org.eclipse.ptp.launch.ENABLE_REGISTER_BOOKKEEPING", ((Boolean)regBookkeeping).booleanValue());
        }
    }

    protected Shell getShell() {
        return super.getShell();
    }

    public void dispose() {
        this.getAdvancedAttributes().clear();
        super.dispose();
    }

    protected void initializeCommonControls(ILaunchConfiguration config) {
        try {
            if (!this.fAttachMode) {
                this.fStopInMain.setSelection(config.getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", true));
            }
            this.initializeAdvancedAttributes(config);
        }
        catch (CoreException coreException) {}
    }

    protected void setInitializeDefault(boolean init) {
        super.setInitializeDefault(init);
    }

    public class AdvancedDebuggerOptionsDialog
    extends Dialog {
        private Button fVarBookKeeping;
        private Button fRegBookKeeping;
        final String[] protocolItems = new String[]{"mi", "mi1", "mi2", "mi3"};
        private Combo fPCombo;

        protected AdvancedDebuggerOptionsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Group group = new Group(composite, 0);
            group.setText(LaunchMessages.getResourceString("PDebuggerTab.Automatically_track_values_of"));
            GridLayout layout = new GridLayout();
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            this.fVarBookKeeping = new Button((Composite)group, 32);
            this.fVarBookKeeping.setText(LaunchMessages.getResourceString("PDebuggerTab.Variables"));
            this.fRegBookKeeping = new Button((Composite)group, 32);
            this.fRegBookKeeping.setText(LaunchMessages.getResourceString("PDebuggerTab.Registers"));
            this.createProtocolCombo(composite, 2);
            this.initialize();
            return composite;
        }

        protected void createProtocolCombo(Composite parent, int colspan) {
            Group comboComp = new Group(parent, 0);
            comboComp.setText("Protocol");
            GridLayout layout = new GridLayout(2, false);
            comboComp.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalSpan = colspan;
            comboComp.setLayoutData((Object)gd);
            this.fPCombo = new Combo((Composite)comboComp, 12);
            this.fPCombo.setLayoutData((Object)new GridData(768));
            this.fPCombo.setItems(this.protocolItems);
        }

        protected void okPressed() {
            this.saveValues();
            super.okPressed();
        }

        private void initialize() {
            String p;
            Map attr = PDebuggerTab.this.getAdvancedAttributes();
            Object varBookkeeping = attr.get("org.eclipse.ptp.launch.ENABLE_VARIABLE_BOOKKEEPING");
            this.fVarBookKeeping.setSelection(varBookkeeping instanceof Boolean ? !((Boolean)varBookkeeping).booleanValue() : true);
            Object regBookkeeping = attr.get("org.eclipse.ptp.launch.ENABLE_REGISTER_BOOKKEEPING");
            this.fRegBookKeeping.setSelection(regBookkeeping instanceof Boolean ? !((Boolean)regBookkeeping).booleanValue() : true);
            Object protocol = attr.get("org.eclipse.ptp.launch.protocol");
            int index = 0;
            if (protocol instanceof String && (p = (String)protocol) != null && p.length() > 0) {
                int i = 0;
                while (i < this.protocolItems.length) {
                    if (this.protocolItems[i].equals(p)) {
                        index = i;
                    }
                    ++i;
                }
            }
            this.fPCombo.select(index);
        }

        private void saveValues() {
            Map attr = PDebuggerTab.this.getAdvancedAttributes();
            Boolean varBookkeeping = this.fVarBookKeeping.getSelection() ? Boolean.FALSE : Boolean.TRUE;
            attr.put("org.eclipse.ptp.launch.ENABLE_VARIABLE_BOOKKEEPING", varBookkeeping);
            Boolean regBookkeeping = this.fRegBookKeeping.getSelection() ? Boolean.FALSE : Boolean.TRUE;
            attr.put("org.eclipse.ptp.launch.ENABLE_REGISTER_BOOKKEEPING", regBookkeeping);
            String protocol = this.fPCombo.getText();
            if (protocol != null && protocol.length() > 0) {
                attr.put("org.eclipse.ptp.launch.protocol", protocol);
            }
            PDebuggerTab.this.updateLaunchConfigurationDialog();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(LaunchMessages.getResourceString("PDebuggerTab.Advanced_Options_Dialog_Title"));
        }
    }
}

