/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.ui.LaunchImages;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.launch.ui.PLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PMainTab
extends PLaunchConfigurationTab {
    protected Text projText = null;
    protected Text appText = null;
    protected Button projButton = null;
    protected Button appButton = null;
    protected WidgetListener listener = new WidgetListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(comp, 1);
        Composite projectComp = new Composite(comp, 0);
        projectComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        projectComp.setLayoutData((Object)new GridData(768));
        Label projLabel = new Label(projectComp, 0);
        projLabel.setText(LaunchMessages.getResourceString("PMainTab.&Project_Label"));
        projLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.projText = new Text(projectComp, 2052);
        this.projText.setLayoutData((Object)new GridData(768));
        this.projText.addModifyListener((ModifyListener)this.listener);
        this.projButton = this.createPushButton(projectComp, LaunchMessages.getResourceString("Tab.common.&Browse_1"), null);
        this.projButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(comp, 1);
        Label appLabel = new Label(projectComp, 0);
        appLabel.setText(LaunchMessages.getResourceString("PMainTab.&Application_Label"));
        appLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.appText = new Text(projectComp, 2052);
        this.appText.setLayoutData((Object)new GridData(768));
        this.appText.addModifyListener((ModifyListener)this.listener);
        this.appButton = this.createPushButton(projectComp, LaunchMessages.getResourceString("Tab.common.B&rowse_2"), null);
        this.appButton.addSelectionListener((SelectionListener)this.listener);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IProject project = this.getDefaultProject((ILaunchConfiguration)configuration);
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
            String name = this.getLaunchConfigurationDialog().generateName(projectName);
            configuration.rename(name);
        }
        configuration.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", projectName);
        configuration.setAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projText.setText(configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", ""));
            this.appText.setText(configuration.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", ""));
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("CommonTab.common.Exception_occurred_reading_configuration_EXCEPTION", e.getStatus().getMessage()));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", this.getFieldContent(this.projText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", this.getFieldContent(this.appText.getText()));
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.getFieldContent(this.projText.getText());
        if (name != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format(LaunchMessages.getResourceString("PMainTab.Project_not_exits"), name));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format(LaunchMessages.getResourceString("PMainTab.Project_is_closed"), name));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format(LaunchMessages.getResourceString("PMainTab.Illegal_project"), status.getMessage()));
                return false;
            }
        }
        if ((name = this.getFieldContent(this.appText.getText())) == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("PMainTab.Application_program_not_specified"));
            return false;
        }
        return true;
    }

    public String getName() {
        return LaunchMessages.getResourceString("PMainTab.Main");
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    public Image getImage() {
        return LaunchImages.getImage("org.eclipse.ptp.launch.main_tab.gif");
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected void handleApplicationButtonSelected() {
        IResource file = this.chooseFile();
        if (file == null) {
            return;
        }
        String fileName = file.getProjectRelativePath().toString();
        this.appText.setText(fileName);
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        this.projText.setText(projectName);
    }

    protected IProject getProject() {
        String projectName = this.projText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getWorkspaceRoot().getProject(projectName);
    }

    protected IResource chooseFile() {
        final IProject project = this.getProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getResourceString("PMainTab.Project_required"), (String)LaunchMessages.getResourceString("PMainTab.Enter_project_before_browsing_for_program"));
            return null;
        }
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider contentProvider = new BaseWorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(LaunchMessages.getResourceString("PMainTab.Program_selection"));
        dialog.setMessage(LaunchMessages.getFormattedResourceString("PMainTab.Choose_program_to_run_from_NAME", project.getName()));
        dialog.setBlockOnOpen(true);
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)project);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0 || !(selection[0] instanceof IFile)) {
                    return new Status(4, PTPCorePlugin.getUniqueIdentifier(), 1, LaunchMessages.getResourceString("PMainTab.Selection_must_be_file"), null);
                }
                try {
                    IResource resource = project.findMember(((IFile)selection[0]).getProjectRelativePath());
                    if (resource == null || resource.getType() != 1) {
                        return new Status(4, PTPCorePlugin.getUniqueIdentifier(), 1, LaunchMessages.getResourceString("PMainTab.Selection_must_be_file"), null);
                    }
                    return new Status(0, PTPCorePlugin.getUniqueIdentifier(), 0, resource.getName(), null);
                }
                catch (Exception exception) {
                    return new Status(4, "org.eclipse.ptp.core", 1, LaunchMessages.getResourceString("PMainTab.Selection_must_be_file"), null);
                }
            }
        });
        if (dialog.open() == 0) {
            return (IResource)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject chooseProject() {
        Object[] projects = this.getWorkspaceRoot().getProjects();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(LaunchMessages.getResourceString("PMainTab.Project_Selection_Title"));
        dialog.setMessage(LaunchMessages.getResourceString("PMainTab.Project_Selection_Message"));
        dialog.setElements(projects);
        IProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject getDefaultProject(ILaunchConfiguration configuration) {
        IEditorPart part;
        Object obj;
        IStructuredSelection ss;
        ISelection selection;
        String projectName = null;
        try {
            projectName = configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        IWorkbenchPage page = PTPLaunchPlugin.getActivePage();
        if (projectName != null && !projectName.equals("")) {
            IProject project = this.getWorkspaceRoot().getProject(projectName);
            if (project != null && project.exists()) {
                return project;
            }
        } else if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IAdaptable) {
            Object o;
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((o = iAdaptable.getAdapter((Class)clazz)) instanceof IResource) {
                return ((IResource)o).getProject();
            }
        }
        if ((part = page.getActiveEditor()) != null) {
            IFile file;
            IEditorInput input = part.getEditorInput();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)input.getAdapter((Class)clazz)) != null) {
                return file.getProject();
            }
        }
        return null;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == PMainTab.this.projButton) {
                PMainTab.this.handleProjectButtonSelected();
            } else if (source == PMainTab.this.appButton) {
                PMainTab.this.handleApplicationButtonSelected();
            } else {
                PMainTab.this.handleProjectButtonSelected();
            }
        }

        public void modifyText(ModifyEvent e) {
            PMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

