/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.mpi.core.Artifact;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ArtifactMarkingVisitor
implements IResourceDeltaVisitor,
IResourceVisitor {
    private static final boolean traceOn = false;
    protected String markerID;

    public ArtifactMarkingVisitor(String markerId) {
        this.markerID = markerId;
    }

    public boolean visitFile(IResource resource) {
        Artifact[] artifacts = ArtifactMarkingVisitor.getPIs(resource);
        return this.visitFile(resource, artifacts);
    }

    public boolean visitFile(IResource resource, Artifact[] artifacts) {
        try {
            this.removeMarkers(resource, this.markerID);
            String fn = resource.getProjectRelativePath().toString();
            if (artifacts != null) {
                this.createMarkers(resource, fn, artifacts);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean visitFile(IResource resource, List artifacts) {
        Artifact[] artifactArray = new Artifact[artifacts.size()];
        int i = 0;
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact element;
            artifactArray[i] = element = (Artifact)iter.next();
            ++i;
        }
        return this.visitFile(resource, artifactArray);
    }

    protected void createMarkers(IResource resource, String fn, Artifact[] artifacts) throws CoreException {
        int i = 0;
        while (i < artifacts.length) {
            Artifact artifact = artifacts[i];
            if (artifact != null) {
                String filename = artifact.getFileName();
                IResource f = resource;
                this.createArtifactMarker(f, artifact, filename);
            }
            ++i;
        }
    }

    protected void createArtifactMarker(IResource resource, Artifact artifact, String fn) throws CoreException {
        Map attrs = this.createCommonMarkerAttrs(resource, artifact, fn);
        attrs.put("message", artifact.getShortName());
        MarkerUtilities.createMarker((IResource)resource, (Map)attrs, (String)this.markerID);
    }

    protected Map createCommonMarkerAttrs(IResource resource, Artifact artifact, String fn) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("priority", new Integer(1));
        attrs.put("lineNumber", new Integer(artifact.getLine()));
        attrs.put("location", artifact.getFileName());
        attrs.put("filename", fn);
        attrs.put("name", artifact.getShortName());
        attrs.put("description", artifact.getDescription());
        attrs.put("charStart", new Integer(artifact.getSourceInfo_().getStart()));
        attrs.put("charEnd", new Integer(artifact.getSourceInfo_().getEnd()));
        attrs.put("constructType", new Integer(artifact.getSourceInfo_().getConstructType()));
        String id = artifact.getUniqueID();
        attrs.put("uniqueID", id);
        attrs.put("theLineNo", Integer.toString(artifact.getLine()));
        return attrs;
    }

    public static Artifact[] getPIs(IResource r) {
        System.out.println("*UNIMPLEMENTED** ArtifactMarkingVisitor.getPIs: " + r.getName());
        return null;
    }

    private void removeMarkers(IResource resource, String markerID) {
        try {
            resource.deleteMarkers(markerID, false, 2);
        }
        catch (CoreException e) {
            System.out.println((Object)e);
            System.out.println(e.toString());
            System.out.println("Problem deleting markers on " + resource.getProjectRelativePath());
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        int type = resource.getType();
        if (delta.getKind() != 2 && type == 1) {
            this.visitFile(resource);
        }
        return true;
    }

    public boolean visit(IResource resource) {
        if (resource.getType() == 1) {
            this.visitFile(resource);
        }
        return true;
    }

    public static void showArtifact(Artifact artifact) {
        System.out.println("Artifact name: " + artifact.getShortName());
        System.out.println("   Description: " + artifact.getDescription());
        System.out.println("   Filename:    " + artifact.getFileName());
    }
}

