/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core.actions;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RemoveMarkerAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        this.removeMarkers();
    }

    public void removeMarkers() {
        IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
        int numMarkers = 0;
        int numErrMarkers = 0;
        String mType = "";
        String meType = "";
        try {
            int depth = 2;
            mType = "org.eclipse.ptp.mpi.core.mpiMarker";
            IMarker[] all = wsResource.findMarkers(mType, false, depth);
            numMarkers = all.length;
            wsResource.deleteMarkers(mType, false, depth);
            meType = "org.eclipse.ptp.mpi.core.mpiErrorMarker";
            IMarker[] allErrs = wsResource.findMarkers(meType, false, depth);
            numErrMarkers = allErrs.length;
            wsResource.deleteMarkers(meType, false, depth);
        }
        catch (CoreException e) {
            System.out.println("RM: exception deleting markers.");
            e.printStackTrace();
        }
        MessageDialog.openInformation((Shell)this.window.getShell(), (String)"MPI artifacts cleared", (String)(String.valueOf(numMarkers) + " MPI Artifact" + this.sIfMult(numMarkers) + " and " + numErrMarkers + " MPI Artifact Error" + this.sIfMult(numErrMarkers) + " " + "have been removed.\n" + "\n"));
    }

    String sIfMult(int num) {
        if (num != 1) {
            return "s";
        }
        return "";
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

