/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.mpi.core.ArtifactMarkingVisitor;
import org.eclipse.ptp.mpi.core.MpiPlugin;
import org.eclipse.ptp.mpi.core.ScanReturn;
import org.eclipse.ptp.mpi.core.analysis.MpiCASTVisitor;
import org.eclipse.ptp.mpi.core.analysis.MpiCPPASTVisitor;
import org.eclipse.ptp.mpi.core.util.AnalysisUtil;
import org.eclipse.ptp.mpi.core.util.ViewActivater;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RunAnalyseBase
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final boolean traceOn = false;
    private static final int INDENT_INCR = 2;
    private boolean runAnalysis = true;
    protected boolean forceEcho = false;
    protected IWorkbenchWindow window;
    protected boolean cancelledByUser = false;
    protected int cumulativeArtifacts = 0;
    protected String name = "MPI";
    protected ArtifactMarkingVisitor visitor;
    private IStructuredSelection selection;
    private boolean keepErr = false;
    private static final String SPACES = "                                                                                            ";
    static /* synthetic */ Class class$0;

    public RunAnalyseBase() {
        this.visitor = new ArtifactMarkingVisitor("org.eclipse.ptp.mpi.core.mpiMarker");
    }

    public RunAnalyseBase(String name, ArtifactMarkingVisitor visitor) {
        this.name = name;
        this.visitor = visitor;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        System.out.println("RunAnalyseBase.run()...");
        this.cancelledByUser = false;
        this.cumulativeArtifacts = 0;
        this.readPreferences();
        String whatToRun = "";
        boolean ranIt = false;
        boolean haveConfirmedWithUser = false;
        if (this.selection == null || this.selection.isEmpty()) {
            MessageDialog.openWarning(null, (String)"No files selected for analysis.", (String)"Please first select your source files.");
            return;
        }
        final List includes = this.getIncludePath();
        if (includes.isEmpty()) {
            MessageDialog.openWarning(null, (String)(String.valueOf(this.name) + " Include Paths Not Found"), (String)("Please first specify the " + this.name + " include paths in the Preferences page."));
        } else {
            Iterator iter = this.selection.iterator();
            while (iter.hasNext()) {
                IResource res;
                Object obj = iter.next();
                if (!(obj instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)obj;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((res = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                whatToRun = this.getPrefacedName(res);
                String multipleMsg = this.selection.size() > 1 ? "\n(Plus other files selected)" : "";
                String msg = "Run Artifact Analysis on " + whatToRun + "?" + multipleMsg;
                boolean runIt = haveConfirmedWithUser;
                runIt = true;
                if (!runIt && !(runIt = MessageDialog.openQuestion(null, (String)"Run Analysis", (String)msg))) {
                    return;
                }
                haveConfirmedWithUser = true;
                ranIt = true;
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            boolean err = RunAnalyseBase.this.runResource(res, 0, includes);
                            RunAnalyseBase.this.keepErr = err;
                        }
                    }, null);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                IContainer parent = res.getParent();
                try {
                    parent.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    System.out.println("Exception refreshing after analysis");
                    e.printStackTrace();
                }
            }
        }
        if (ranIt) {
            String pisFound = "\nNumber of " + this.name + " Artifacts found: " + this.cumulativeArtifacts;
            if (this.cancelledByUser) {
                MessageDialog.openInformation(null, (String)"Partial Analysis Complete.", (String)("Partial Analysis complete.  Cancelled by User." + pisFound));
            } else {
                String msg = "Analysis is complete for:  " + whatToRun;
                if (!this.keepErr) {
                    String sMsg = String.valueOf(this.cumulativeArtifacts) + " " + this.name + " Artifacts found in " + whatToRun;
                    this.showStatusMessage(sMsg, "RunAnalyseBase.run()");
                    MessageDialog.openInformation(null, (String)"Analysis complete.", (String)(String.valueOf(msg) + pisFound));
                    this.showStatusMessage(sMsg, "RunAnalyseBase.run()");
                    this.activateArtifactView();
                } else {
                    this.showStatusMessage(msg, "RunAnalyseBase.run() error");
                    msg = "Analysis for: " + whatToRun + " completed with errors. See Tasks View.";
                    MessageDialog.openError(null, (String)"Analysis completed with errors", (String)(String.valueOf(msg) + pisFound));
                }
            }
        }
    }

    protected void activateArtifactView() {
        ViewActivater.activateView("org.eclipse.ptp.mpi.core.views.MPITableView");
    }

    protected List getIncludePath() {
        return MpiPlugin.getDefault().getMpiIncludeDirs();
    }

    private void showStatusMessage(String message, String debugMessage) {
        IWorkbenchWindow ww = MpiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = ww.getActivePage();
        IViewReference[] viewRefs = page.getViewReferences();
        int j = 0;
        while (j < viewRefs.length) {
            IViewReference reference = viewRefs[j];
            IViewPart vp = reference.getView(false);
            if (vp != null) {
                vp.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
            }
            ++j;
        }
    }

    protected void readPreferences() {
        Preferences pref = MpiPlugin.getDefault().getPluginPreferences();
        this.runAnalysis = pref.getBoolean("runAnalysis");
        this.forceEcho = pref.getBoolean("forceEcho");
    }

    protected boolean runResource(IResource resource, int indent, List includes) {
        indent += 2;
        boolean foundError = false;
        if (!this.cancelledByUser) {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String filename = file.getName();
                if (AnalysisUtil.validForAnalysis(filename)) {
                    this.runAnalysis = true;
                    if (this.runAnalysis) {
                        ScanReturn results = this.analyse(file, includes);
                        boolean bl = foundError = foundError || results == null || results.wasError();
                        if (results != null) {
                            List artifacts = results.getArtifactList();
                            this.visitor.visitFile(resource, artifacts);
                        }
                    }
                }
                return foundError;
            }
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] mems = container.members();
                    int i = 0;
                    while (i < mems.length) {
                        boolean err = this.runResource(mems[i], indent, includes);
                        foundError = foundError || err;
                        ++i;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else {
            String name = "";
            if (resource instanceof IResource) {
                IResource res = resource;
                IPath path = res.getProjectRelativePath();
                name = path.toString();
            }
            System.out.println("Cancelled by User, aborting analysis on subsequent files... " + name);
        }
        return foundError;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ScanReturn analyse(IFile file, List includes) {
        block8: {
            nr = null;
            errMsg = null;
            op = null;
            try {
                op = new AnalyseWithProgress(file, includes);
                activeShell = this.window.getShell();
                pmd = new ProgressMonitorDialog(activeShell);
                pmd.run(true, true, (IRunnableWithProgress)op);
                nr = op.getResults();
            }
            catch (InvocationTargetException e) {
                errMsg = "RunAnalyseBase: InvocationTargetException in analysis for " + file.getLocation();
                System.out.println(errMsg);
                e.printStackTrace();
                origExcp = e.getTargetException();
                System.out.println("Original target exception is: " + origExcp);
                System.out.println("   stack trace printed to stdout.");
                origExcp.printStackTrace();
                te = origExcp;
                ste = te.getStackTrace();
                System.out.println("   Stack trace:");
                j = 0;
                ** while (j < ste.length)
            }
lbl-1000:
            // 1 sources

            {
                el = ste[j];
                System.out.println("     " + (j + 1) + " " + el.toString());
                ++j;
                continue;
lbl28:
                // 1 sources

                break block8;
            }
            catch (InterruptedException e) {
                System.out.println("RunAnalyseBase: Interrupted Analysis for " + file.getProjectRelativePath());
                System.out.println("   reason: " + e.getMessage());
                if (op != null) {
                    nr = op.getResults();
                }
                this.cancelledByUser = true;
            }
        }
        if (nr == null) {
            System.out.println("ScanReturn result is NULL.  No results for " + file.getProjectRelativePath());
            shell = Display.getCurrent().getActiveShell();
            errMsg = "Error: No results were returned from analysis of " + file.getProjectRelativePath();
            MessageDialog.openError((Shell)shell, (String)"Error in Analysis", (String)errMsg);
        } else {
            System.out.println("RunAnalyzeBase: ScanReturn received for " + file.getName());
            System.out.println("   Analysis err? = " + nr.wasError());
        }
        if (nr != null && (wasError = nr.wasError())) {
            System.out.println("RunAnalyseBase.analyse...Error...");
        }
        return nr;
    }

    private String getSpaces(int indent) {
        String indentSpace = "";
        try {
            indentSpace = SPACES.substring(0, indent);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.println("RunAnalyseBase: Nesting level " + indent + " exceeds print indent; INCR at each level is " + 2);
        }
        return indentSpace;
    }

    void println(String str) {
        System.out.println(str);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public String getPrefacedName(Object obj) {
        String preface = "";
        if (obj instanceof IFolder) {
            preface = "Contents of Folder: ";
        } else if (obj instanceof IProject) {
            preface = "Contents of Project: ";
        } else if (obj instanceof IFile) {
            preface = "Source file: ";
        }
        String res = String.valueOf(preface) + ((IResource)obj).getName();
        return res;
    }

    public ScanReturn doArtifactAnalysis(IFile file, List includes_) {
        ScanReturn msr = new ScanReturn();
        String fileName = file.getName();
        ParserLanguage lang = AnalysisUtil.getLanguageFromFile(file);
        try {
            IASTTranslationUnit astTransUnit = CDOM.getInstance().getASTService().getTranslationUnit(file, CDOM.getInstance().getCodeReaderFactory(0));
            if (lang == ParserLanguage.CPP) {
                astTransUnit.accept((ASTVisitor)new MpiCPPASTVisitor(includes_, fileName, msr));
            } else if (lang == ParserLanguage.C) {
                astTransUnit.accept((ASTVisitor)new MpiCASTVisitor(includes_, fileName, msr));
            }
        }
        catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {}
        return msr;
    }

    public class AnalyseWithProgress
    implements IRunnableWithProgress {
        private IFile file_;
        private ScanReturn scanReturn_;
        List includes_;

        public AnalyseWithProgress(IFile file, List includes) {
            this.file_ = file;
            this.includes_ = includes;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.subTask("Starting Analysis...");
            String rawPath = this.file_.getRawLocation().toString();
            RunAnalyseBase.this.println("RunAnalyseBase:              file = " + this.file_.getLocation());
            monitor.subTask("Running analysis on " + rawPath);
            if (monitor.isCanceled()) {
                System.out.println("RunAnalyseBase, progressMonitor canceled...before");
                throw new InterruptedException("Analysis canceled by user");
            }
            this.scanReturn_ = RunAnalyseBase.this.doArtifactAnalysis(this.file_, this.includes_);
            if (monitor.isCanceled()) {
                System.out.println("RunAnalyseBase, progressMonitor canceled...after");
                throw new InterruptedException("Analysis canceled by user");
            }
            monitor.subTask("Analysis done.");
            int numArtifacts = this.scanReturn_.getArtifactList().size();
            RunAnalyseBase.this.cumulativeArtifacts += numArtifacts;
            System.out.println("Artifacts found for " + this.file_.getProjectRelativePath() + ": " + numArtifacts);
            System.out.println("   Total # found: " + RunAnalyseBase.this.cumulativeArtifacts);
            monitor.subTask("All done.");
            monitor.done();
        }

        public ScanReturn getResults() {
            return this.scanReturn_;
        }
    }
}

