/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.ptp.mpi.core.ScanReturn;
import org.eclipse.ptp.mpi.core.analysis.GeneralASTVisitorBehavior;

public class MpiCASTVisitor
extends CASTVisitor {
    private static final String MPI_PREFIX = "MPI_";
    private GeneralASTVisitorBehavior generalMpiVisitorBehavior;

    public MpiCASTVisitor(List mpiIncludes, String fileName, ScanReturn msr) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        this.generalMpiVisitorBehavior = new GeneralASTVisitorBehavior(mpiIncludes, fileName, msr);
    }

    public int visit(IASTStatement statement) {
        return this.generalMpiVisitorBehavior.visit(statement);
    }

    public int visit(IASTDeclaration declaration) {
        return this.generalMpiVisitorBehavior.visit(declaration);
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            System.out.println("func signature=" + signature);
            if (signature.startsWith(MPI_PREFIX) && astExpr instanceof IASTIdExpression) {
                IASTName funcName = ((IASTIdExpression)astExpr).getName();
                this.generalMpiVisitorBehavior.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof IASTLiteralExpression) {
            this.generalMpiVisitorBehavior.processMacroLiteral((IASTLiteralExpression)expression);
        }
        return 3;
    }
}

