/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLinkageSpecification;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTUsingDirective;
import org.eclipse.ptp.mpi.core.ScanReturn;
import org.eclipse.ptp.mpi.core.analysis.GeneralASTVisitorBehavior;

public class MpiCPPASTVisitor
extends CPPASTVisitor {
    private static final String MPI_PREFIX = "MPI_";
    private static final String MPICPP_PREFIX = "MPI::";
    private GeneralASTVisitorBehavior generalMpiVisitorBehavior;
    private boolean usingNamespaceMPI;

    public MpiCPPASTVisitor(List mpiIncludes, String fileName, ScanReturn msr) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        this.generalMpiVisitorBehavior = new GeneralASTVisitorBehavior(mpiIncludes, fileName, msr);
        this.usingNamespaceMPI = false;
    }

    public int visit(IASTStatement statement) {
        return this.generalMpiVisitorBehavior.visit(statement);
    }

    public int visit(IASTDeclaration declaration) {
        CPPASTUsingDirective cppASTUsingDirective;
        if (declaration instanceof CPPASTUsingDirective && "MPI".equals((cppASTUsingDirective = (CPPASTUsingDirective)declaration).getQualifiedName().getRawSignature())) {
            this.usingNamespaceMPI = true;
        }
        if (declaration instanceof CPPASTLinkageSpecification && declaration.getFileLocation() == null) {
            return 3;
        }
        if (declaration.getFileLocation() == null) {
            System.out.println("null decl");
        }
        return this.generalMpiVisitorBehavior.visit(declaration);
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            System.out.println("func signature=" + signature);
            if (this.usingNamespaceMPI || signature.startsWith(MPI_PREFIX) || signature.startsWith(MPICPP_PREFIX)) {
                IASTName funcName = null;
                if (astExpr instanceof CPPASTFieldReference) {
                    CPPASTFieldReference cppFieldReference = (CPPASTFieldReference)astExpr;
                    funcName = cppFieldReference.getFieldName();
                } else if (astExpr instanceof IASTIdExpression) {
                    funcName = ((IASTIdExpression)astExpr).getName();
                }
                this.generalMpiVisitorBehavior.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof CPPASTIdExpression && !(expression.getParent() instanceof IASTFunctionCallExpression)) {
            this.generalMpiVisitorBehavior.processIdExprAsLiteral((IASTIdExpression)((CPPASTIdExpression)expression));
        } else if (expression instanceof IASTLiteralExpression) {
            this.generalMpiVisitorBehavior.processMacroLiteral((IASTLiteralExpression)expression);
        }
        return 3;
    }
}

