/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core.views;

import java.net.URL;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.mpi.core.Artifact;
import org.eclipse.ptp.mpi.core.MpiArtifactManager;
import org.eclipse.ptp.mpi.core.MpiPlugin;
import org.eclipse.ptp.mpi.core.util.AnalysisUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MPITableView
extends ViewPart {
    private TableViewer viewer;
    private Action mpiInfoAction;
    private Action filterAction;
    private Action doubleClickAction;
    private static final boolean traceOn = false;
    private static final boolean traceStatusLine = false;
    protected ViewerSorter nameSorter;
    protected GenericSorter lineNoSorter;
    protected FilenameSorter filenameSorter;
    protected GenericSorter orderSorter;
    protected GenericSorter nameArtifactSorter;
    protected GenericSorter constructSorter;
    private IMarker selectedMarker_ = null;
    protected StackList remediatedPIs_ = new StackList();
    protected StackList remediatedMarkers_ = new StackList();
    protected UpdateVisitor visitor_ = new UpdateVisitor();
    private static final String THINGNAME = "MPI Artifact";
    private static final String THINGNAMES = "MPI Artifacts";

    protected Artifact getMpiArtifact(IMarker marker) {
        String id = null;
        Artifact mpiA = null;
        try {
            id = (String)marker.getAttribute("uniqueID");
            mpiA = MpiArtifactManager.getMpiArtifact(id);
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(e.getMessage()) + " ... MPITV, CoreException getting artifact from hashMap; " + THINGNAME + " id=" + id);
        }
        catch (NullPointerException ne) {
            System.out.println(String.valueOf(ne.getMessage()) + " ... MPITV, NullPtrExcp getting artifact from hashMap;" + THINGNAME + " id=" + id);
        }
        return mpiA;
    }

    private final String getConstructStr(IMarker marker) throws CoreException {
        Integer constructType = (Integer)marker.getAttribute("constructType");
        return Artifact.CONSTRUCT_TYPE_NAMES[constructType];
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 66306);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] STD_HEADINGS = new String[]{" ", THINGNAME, "Filename", "LineNo", "Construct"};
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 1, true));
        TableColumn tc0 = new TableColumn(table, 0);
        tc0.setText(STD_HEADINGS[0]);
        tc0.setAlignment(16384);
        tc0.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn tc1 = new TableColumn(table, 0);
        tc1.setText(STD_HEADINGS[1]);
        tc1.setAlignment(16384);
        tc1.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn tc2 = new TableColumn(table, 0);
        tc2.setText(STD_HEADINGS[2]);
        tc2.setAlignment(16384);
        tc2.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        TableColumn tc3 = new TableColumn(table, 0);
        tc3.setText(STD_HEADINGS[3]);
        tc3.setAlignment(16384);
        tc3.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        TableColumn tc4 = new TableColumn(table, 0);
        tc4.setText(STD_HEADINGS[4]);
        tc4.setAlignment(16384);
        tc4.setResizable(true);
        tc0.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MPITableView.this.viewer.setSorter(null);
                MPITableView.this.viewer.setSorter(MPITableView.this.nameSorter);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        tc1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MPITableView.this.nameArtifactSorter.sort();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        tc2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MPITableView.this.filenameSorter.sort();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        tc3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MPITableView.this.lineNoSorter.sort();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        tc4.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MPITableView.this.constructSorter.sort();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof Table) {
                    Table t = (Table)obj;
                    t.getSelectionIndex();
                }
            }
        });
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.nameSorter = new NameSorter();
        this.viewer.setSorter(this.nameSorter);
        this.lineNoSorter = new LineNoSorter();
        this.nameArtifactSorter = new NameArtifactSorter();
        this.filenameSorter = new FilenameSorter();
        this.constructSorter = new ConstructSorter();
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof IMarker) {
                    MPITableView.this.selectedMarker_ = (IMarker)obj;
                }
                MPITableView.this.showStatusMessage("", "selectionChanged");
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MPITableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.mpiInfoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.filterAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.mpiInfoAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.mpiInfoAction);
    }

    private void makeActions() {
        this.makeShowInfoAction();
        this.makeFilterAction();
        this.makeDoubleClickAction();
    }

    private void makeShowInfoAction() {
        this.mpiInfoAction = new Action(){

            public void run() {
                String title = "MPI Artifact information";
                if (MPITableView.this.selectedMarker_ != null) {
                    String idFromMarker = MPITableView.this.selectedMarker_.getAttribute("uniqueID", null);
                    if (idFromMarker == null) {
                        System.out.println("MPITV: exception reading marker ID");
                        return;
                    }
                    StringBuffer info = new StringBuffer();
                    Artifact mpiA = MpiArtifactManager.getMpiArtifact(idFromMarker);
                    info.append("\nFile name: ").append(mpiA.getFileName());
                    info.append("\nLine number: ").append(mpiA.getLine());
                    info.append("\nName: ").append(mpiA.getShortName());
                    info.append("\nDescription: ").append(mpiA.getDescription());
                    MessageDialog.openInformation(null, (String)title, (String)info.toString());
                } else {
                    MessageDialog.openInformation(null, (String)title, (String)"No MPI Artifact selected.");
                }
            }
        };
        this.mpiInfoAction.setText("Show Info");
        this.mpiInfoAction.setToolTipText("Show detailed info for selected MPI Artifact");
        this.mpiInfoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void makeFilterAction() {
        this.filterAction = new Action(){

            public void run() {
                MPITableView.this.showMessage("Filter MPI Artifacts\nDetermine which MPI Artifacts are shown in this view.");
            }
        };
        this.filterAction.setText("Filter MPI Artifacts");
        this.filterAction.setToolTipText("Filter which MPI Artifacts are shown in this view");
    }

    private void makeDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = MPITableView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                IMarker marker = (IMarker)obj;
                try {
                    IFile f = (IFile)marker.getResource();
                    Artifact mpiA = MPITableView.this.getMpiArtifact(marker);
                    if (mpiA != null) {
                        mpiA.getLine();
                    }
                    int lineNo = MPITableView.this.getMarkerLineNo(marker);
                    if (f != null && f.exists()) {
                        IWorkbenchPage wbp = MPITableView.this.getSite().getPage();
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)wbp, (IFile)f);
                        MarkerUtilities.setLineNumber((IMarker)marker, (int)lineNo);
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                        MPITableView.this.showStatusMessage("", "double click action");
                    }
                }
                catch (Exception e) {
                    System.out.println("MPITV.doubleclickAction: Error positioning editor page from marker line number");
                    MPITableView.this.showStatusMessage("Error positioning editor from marker line number", "error marker goto");
                    e.printStackTrace();
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MPITableView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"MPI Artifact View", (String)message);
    }

    private void showStatusMessage(String message, String debugMessage) {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
        this.getViewSite().getActionBars().getStatusLineManager().update(true);
    }

    public void setFocus() {
        this.showStatusMessage("", "setFocus");
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
    }

    public void showMarker(IMarker marker) {
        System.out.println("Marker-------  IMarker.LINE_NUMBER=lineNumber");
        try {
            Map attrs = marker.getAttributes();
            Iterator iter = attrs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                System.out.println("   " + e.getKey() + " " + e.getValue());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ImageDescriptor makeImageDescriptor(String iconName) {
        URL url = MpiPlugin.getDefault().find((IPath)new Path(iconName));
        ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
        return id;
    }

    protected void pushRemedInfo(Artifact mpiA, IMarker marker) {
        this.remediatedPIs_.push(mpiA);
        this.remediatedMarkers_.push(marker);
        this.checkUndoStatus();
    }

    protected void checkUndoStatus() {
    }

    protected int getMarkerLineNo(IMarker marker) {
        int lineNo = this.getIntAttr(marker, "lineNumber");
        return lineNo;
    }

    protected int getMarkerNewLineNo(IMarker marker) {
        int lineNo = this.getIntAttr(marker, "theNewLineNo");
        return lineNo;
    }

    protected int getIntAttr(IMarker marker, String attr) {
        String temp = null;
        try {
            temp = marker.getAttribute(attr).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("MPITV: Marker lineNo(" + attr + ") invalid; using 0");
            return 0;
        }
        int lineNo = 0;
        try {
            lineNo = Integer.parseInt(temp);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MPITV: Marker lineNo(" + temp + " from attr " + attr + ") invalid (NumberFormatException); using 0");
        }
        return lineNo;
    }

    protected String getAttribute(IMarker marker, String attr) {
        String result = null;
        try {
            result = (String)marker.getAttribute(attr);
        }
        catch (Exception e) {
            System.out.println("** Exception getting marker attribute " + e);
            e.printStackTrace();
        }
        return result;
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    IResourceChangeListener {
        private IResource input;
        private boolean hasRegistered = false;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (!this.hasRegistered) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
                this.hasRegistered = true;
            }
            if (newInput instanceof IResource) {
                this.input = (IResource)newInput;
            }
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public Object[] getElements(Object parent) {
            Object[] objs = null;
            try {
                String id = "org.eclipse.ptp.mpi.core.mpiMarker";
                if (this.input == null) {
                    // empty if block
                }
                objs = this.input.findMarkers(id, false, 2);
            }
            catch (CoreException e) {
                System.out.println("MPITV, exception getting model elements (markers for Table view)");
                e.printStackTrace();
            }
            return objs;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            Control ctrl = MPITableView.this.viewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().syncExec(new Runnable(this, delta){
                    final /* synthetic */ ViewContentProvider this$1;
                    private final /* synthetic */ IResourceDelta val$delta;
                    {
                        this.this$1 = viewContentProvider;
                        this.val$delta = iResourceDelta;
                    }

                    public void run() {
                        try {
                            this.this$1.processResourceChangeDelta(this.val$delta);
                            MPITableView.access$0(ViewContentProvider.access$0(this.this$1)).refresh();
                        }
                        catch (Exception e) {
                            System.out.println("MPITV: Exception refreshing viewer: " + e);
                            e.printStackTrace();
                        }
                    }
                });
            }
        }

        private void printResourcesChanged(IResourceDelta delta, int indent) {
            this.printOneResourceChanged(delta, indent);
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.printResourcesChanged(children[i], indent + 1);
                ++i;
            }
        }

        private void printOneResourceChanged(IResourceDelta delta, int indent) {
            StringBuffer buf = new StringBuffer(80);
            int i = 0;
            while (i < indent) {
                buf.append("  ");
                ++i;
            }
            switch (delta.getKind()) {
                case 1: {
                    buf.append("ADDED");
                    break;
                }
                case 2: {
                    buf.append("REMOVED");
                    break;
                }
                case 4: {
                    buf.append("CHANGED");
                    this.testDelta(delta);
                    break;
                }
                default: {
                    buf.append("[");
                    buf.append(delta.getKind());
                    buf.append("]");
                }
            }
            buf.append(" ");
            buf.append(delta.getResource());
            System.out.println(buf);
        }

        private void testDelta(IResourceDelta delta) {
            System.out.print("Resource ");
            System.out.print(delta.getFullPath());
            System.out.println(" has changed.");
            int flags = delta.getFlags();
            if ((flags & 0x100) != 0) {
                System.out.println("--> Content Change");
            }
            if ((flags & 0x40000) != 0) {
                System.out.println("--> Content Replaced");
            }
            if ((flags & 0x20000) != 0) {
                System.out.println("--> Marker Change");
            }
        }

        protected void processResourceChangeDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)MPITableView.this.visitor_);
            }
            catch (CoreException e2) {
                System.out.println("Error in PITV.processResourceChangeDelta()..");
                e2.printStackTrace();
            }
        }

        static /* synthetic */ MPITableView access$0(ViewContentProvider viewContentProvider) {
            return viewContentProvider.MPITableView.this;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private HashMap iconHash = new HashMap();

        ViewLabelProvider() {
        }

        public String getText(Object o) {
            String temp = super.getText(o);
            return temp;
        }

        public String getColumnText(Object obj, int index) {
            if (obj == null) {
                System.out.println("MPITV: LabelProv obj is null; index=" + index);
                return "MPITV obj null";
            }
            IMarker marker = (IMarker)obj;
            try {
                switch (index) {
                    case 1: {
                        String id = (String)marker.getAttribute("name");
                        return id;
                    }
                    case 2: {
                        return (String)marker.getAttribute("filename");
                    }
                    case 3: {
                        String x = "lineNumber";
                        String line = marker.getAttribute(x).toString();
                        return line;
                    }
                    case 4: {
                        return MPITableView.this.getConstructStr(marker);
                    }
                }
                return "";
            }
            catch (CoreException coreException) {
                return "MPITV error";
            }
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                case 0: {
                    return this.getCustomImage(obj);
                }
            }
            return null;
        }

        private Image getCustomImage(Object obj) {
            String iconName = "icons/mpi.gif";
            Image img = (Image)this.iconHash.get(iconName);
            if (img == null) {
                URL url = MpiPlugin.getDefault().find((IPath)new Path(iconName));
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
                img = id.createImage();
                this.iconHash.put(iconName, img);
            }
            return img;
        }

        public void dispose() {
            Iterator iter = this.iconHash.values().iterator();
            while (iter.hasNext()) {
                Image img = (Image)iter.next();
                img.dispose();
            }
            super.dispose();
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    abstract class GenericSorter
    extends ViewerSorter {
        protected boolean ascending = true;

        GenericSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int result = 0;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            Collator collator = this.getCollator();
            if (e1 instanceof IMarker) {
                try {
                    IMarker m1 = (IMarker)e1;
                    IMarker m2 = (IMarker)e2;
                    String name1 = (String)m1.getAttribute("name");
                    String file1 = (String)m1.getAttribute("filename");
                    String line1 = m1.getAttribute("theLineNo").toString();
                    String construct1 = MPITableView.this.getConstructStr(m1);
                    String sort1 = this.combine(name1, file1, line1, construct1);
                    String name2 = (String)m2.getAttribute("name");
                    String file2 = (String)m2.getAttribute("filename");
                    String line2 = m2.getAttribute("theLineNo").toString();
                    String construct2 = MPITableView.this.getConstructStr(m2);
                    String sort2 = this.combine(name2, file2, line2, construct2);
                    result = this.ascending ? collator.compare(sort1, sort2) : collator.compare(sort2, sort1);
                    return result;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }

        protected String combine(String name, String file, String line, String construct) {
            return null;
        }

        public void sort() {
            if (this == MPITableView.this.viewer.getSorter()) {
                this.ascending = !this.ascending;
                MPITableView.this.viewer.setSorter(null);
            } else {
                this.ascending = true;
            }
            MPITableView.this.viewer.setSorter((ViewerSorter)this);
        }
    }

    class LineNoSorter
    extends GenericSorter {
        LineNoSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof IMarker) {
                try {
                    IMarker m1 = (IMarker)e1;
                    String temp = (String)m1.getAttribute("theLineNo");
                    int line1 = Integer.parseInt(temp);
                    IMarker m2 = (IMarker)e2;
                    temp = (String)m2.getAttribute("theLineNo");
                    int line2 = Integer.parseInt(temp);
                    int result = 0;
                    result = this.ascending ? line1 - line2 : line2 - line1;
                    return result;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
    }

    class NameArtifactSorter
    extends GenericSorter {
        NameArtifactSorter() {
        }

        protected String combine(String name, String file, String line, String construct) {
            StringBuffer result = new StringBuffer(name);
            result.append(" - ");
            result.append(file);
            result.append(" - ");
            result.append(line);
            result.append(" - ");
            result.append(construct);
            return result.toString();
        }
    }

    class FilenameSorter
    extends GenericSorter {
        FilenameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            int res = 0;
            try {
                IMarker m1 = (IMarker)e1;
                IMarker m2 = (IMarker)e2;
                String file1 = (String)m1.getAttribute("filename");
                String file2 = (String)m2.getAttribute("filename");
                System.out.println("ascending=" + this.ascending);
                res = this.ascending ? this.collator.compare(file1, file2) : this.collator.compare(file2, file1);
                if (res == 0) {
                    String line1 = m1.getAttribute("theLineNo").toString();
                    String line2 = m2.getAttribute("theLineNo").toString();
                    int l1 = Integer.parseInt(line1);
                    int l2 = Integer.parseInt(line2);
                    res = this.ascending ? l1 - l2 : l2 - l1;
                }
                if (res == 0) {
                    res = this.ascending ? this.collator.compare(MPITableView.this.getConstructStr(m1), MPITableView.this.getConstructStr(m2)) : this.collator.compare(MPITableView.this.getConstructStr(m2), MPITableView.this.getConstructStr(m1));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return res;
        }
    }

    class ConstructSorter
    extends GenericSorter {
        ConstructSorter() {
        }

        protected String combine(String name, String file, String line, String construct) {
            StringBuffer result = new StringBuffer(construct);
            result.append(" - ");
            result.append(name);
            result.append(" - ");
            result.append(file);
            result.append(" - ");
            result.append(line);
            return result.toString();
        }
    }

    public class StackList {
        private LinkedList list = new LinkedList();

        public void push(Object v) {
            this.list.addFirst(v);
        }

        public Object top() {
            return this.list.getFirst();
        }

        public Object pop() {
            return this.list.removeFirst();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    public class UpdateVisitor
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            resource.getName();
            if (resource.getType() == 1) {
                if (delta.getKind() == 4) {
                    IFile f = (IFile)resource;
                    int flags = delta.getFlags();
                    int contentChanged = flags & 0x100;
                    if (AnalysisUtil.validForAnalysis(f.getName())) {
                        IMarkerDelta[] mDeltas = delta.getMarkerDeltas();
                        int len = mDeltas.length;
                        int j = 0;
                        while (j < len) {
                            IMarkerDelta delta3 = mDeltas[j];
                            IMarker m = delta3.getMarker();
                            String ln = "lineNumber";
                            String[] props = new String[]{ln};
                            MPITableView.this.viewer.update((Object)m, props);
                            ++j;
                        }
                    }
                } else if (delta.getKind() == 1) {
                    System.out.println("Resource added.");
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 262144) {
                    System.out.println("Resource replaced.");
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 2) {
                    System.out.println("Resource removed.");
                    this.checkMarkerDeltas(delta);
                }
            }
            return true;
        }

        private void checkMarkerDeltas(IResourceDelta delta) {
            IMarkerDelta[] md1 = delta.getMarkerDeltas();
            int len = md1.length;
            System.out.println("       ... found " + len + " markerDeltas.");
        }

        private void showMarkerDeltaKind(IMarkerDelta delta3) {
            IMarker m = delta3.getMarker();
            switch (delta3.getKind()) {
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            try {
                m.getAttribute("uniqueID").toString();
                m.getAttribute("lineNumber").toString();
                m.getAttribute("theLineNo").toString();
            }
            catch (Exception e1) {
                System.out.println("MPITV.UpdateVisitor error getting marker info ");
                e1.printStackTrace();
            }
        }
    }
}

