/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core;

import java.util.Date;
import org.eclipse.ptp.mpi.core.MpiArtifactManager;
import org.eclipse.ptp.mpi.core.util.SourceInfo;

public class Artifact {
    private int line_;
    private int column_;
    private String fileName_;
    private String description_;
    private String shortName_;
    private String primaryfileName_;
    private int newline_;
    private String id_;
    private String uniqueID_;
    private static long now_ = new Date().getTime();
    private SourceInfo sourceInfo_;
    public static final int NONE = 0;
    public static final int FUNCTION_CALL = 1;
    public static final int CONSTANT = 2;
    public static final String[] CONSTRUCT_TYPE_NAMES = new String[]{"None", "Function Call", "Constant"};

    public Artifact(String fileName, int line, int column, String shortName, String desc, SourceInfo sourceInfo) {
        this.line_ = line;
        this.newline_ = line;
        this.column_ = column;
        this.fileName_ = fileName;
        this.shortName_ = shortName;
        this.sourceInfo_ = sourceInfo;
        this.setUniqueID();
        MpiArtifactManager.addMpiArtifactToHash(this);
    }

    public Artifact(String fileName, int line, int column, String shortName, String desc, boolean ignore, String primaryFileName, SourceInfo sourceInfo) {
        this(fileName, line, column, shortName, desc, sourceInfo);
        this.primaryfileName_ = primaryFileName;
    }

    private void setUniqueID() {
        this.uniqueID_ = Long.toString(now_++, 36);
    }

    public String getUniqueID() {
        return this.uniqueID_;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("MpiArtifact");
        buf.append(" ");
        buf.append(" id=").append(this.id_);
        buf.append(" ").append(this.shortName_);
        buf.append(" line=").append(this.line_).append(" filename=").append(this.fileName_);
        buf.append(" desc=").append(this.description_);
        buf.append(" start=").append(this.getSourceInfo_().getStart());
        buf.append(" end=").append(this.getSourceInfo_().getEnd());
        return buf.toString();
    }

    public int getColumn() {
        return this.column_;
    }

    public void setColumn(int column_) {
        this.column_ = column_;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description_) {
        this.description_ = description_;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public void setFileName(String fileName_) {
        this.fileName_ = fileName_;
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String id_) {
        this.id_ = id_;
    }

    public int getLine() {
        return this.line_;
    }

    public void setLine(int line_) {
        this.line_ = line_;
    }

    public String getPrimaryfileName() {
        return this.primaryfileName_;
    }

    public void setPrimaryfileName(String primaryfileName_) {
        this.primaryfileName_ = primaryfileName_;
    }

    public String getShortName() {
        return this.shortName_;
    }

    public void setShortName(String shortName_) {
        this.shortName_ = shortName_;
    }

    public SourceInfo getSourceInfo_() {
        return this.sourceInfo_;
    }

    public int getNewline_() {
        return this.newline_;
    }
}

