/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.mpi.core.analysis;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.mpi.core.Artifact;
import org.eclipse.ptp.mpi.core.MpiPlugin;
import org.eclipse.ptp.mpi.core.ScanReturn;
import org.eclipse.ptp.mpi.core.analysis.DeclarationFinder;
import org.eclipse.ptp.mpi.core.util.DOMDisplaySearchNames;
import org.eclipse.ptp.mpi.core.util.SourceInfo;
import org.eclipse.search.ui.text.Match;

public class GeneralASTVisitorBehavior {
    private static final String MPI_CALL = "MPI call";
    private static final String MPI_CONSTANT = "MPI constant";
    private final List includes_;
    private final String fileName;
    private final ScanReturn scanReturn;
    private static final String STRING_QUOTE = "\"";

    public GeneralASTVisitorBehavior(List includes, String fileName, ScanReturn scanReturn) {
        this.includes_ = includes;
        this.fileName = fileName;
        this.scanReturn = scanReturn;
    }

    public int visit(IASTStatement statement) {
        if (this.preprocessorIncluded((IASTNode)statement)) {
            return 1;
        }
        return 3;
    }

    public int visit(IASTDeclaration declaration) {
        if (this.preprocessorIncluded((IASTNode)declaration)) {
            return 1;
        }
        return 3;
    }

    public void processFuncName(IASTName funcName, IASTExpression astExpr) {
        SourceInfo sourceInfo;
        CSearchResult result;
        DeclarationFinder finder = this.searchDeclaration(funcName);
        if (finder != null && this.isMPICall(result = finder.getResult()) && (sourceInfo = this.getSourceInfo(astExpr, 1)) != null) {
            this.scanReturn.addMpiArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, funcName.toString(), MPI_CALL, sourceInfo));
        }
    }

    public void processMacroLiteral(IASTLiteralExpression expression) {
        IASTNodeLocation[] locations = expression.getNodeLocations();
        if (locations.length == 1 && locations[0] instanceof IASTMacroExpansion) {
            SourceInfo sourceInfo;
            IASTMacroExpansion astMacroExpansion = (IASTMacroExpansion)locations[0];
            IASTPreprocessorMacroDefinition preprocessorMacroDefinition = astMacroExpansion.getMacroDefinition();
            String shortName = preprocessorMacroDefinition.getName().toString();
            IASTNodeLocation[] preprocessorLocations = preprocessorMacroDefinition.getNodeLocations();
            while (preprocessorLocations.length == 1 && preprocessorLocations[0] instanceof IASTMacroExpansion) {
                preprocessorLocations = ((IASTMacroExpansion)preprocessorLocations[0]).getMacroDefinition().getNodeLocations();
            }
            if (preprocessorLocations.length == 1 && this.isMPIInclude((IPath)new Path(preprocessorLocations[0].asFileLocation().getFileName())) && (sourceInfo = this.getSourceInfo(astMacroExpansion)) != null) {
                this.scanReturn.addMpiArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, shortName, MPI_CONSTANT, sourceInfo));
            }
        }
    }

    private boolean isMPICall(CSearchResult searchResult) {
        if (searchResult != null && searchResult.getMatchCount() > 0) {
            Match[] matches = searchResult.getMatches(searchResult.getElements()[0]);
            int i = 0;
            while (i < matches.length) {
                CSearchMatch cMatch = (CSearchMatch)matches[i];
                IPath includeFilePath = cMatch.getSearchMatch().getLocation();
                if (this.isMPIInclude(includeFilePath)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isMPIInclude(IPath includeFilePath) {
        Iterator it = this.includes_.iterator();
        while (it.hasNext()) {
            String includeDir = (String)it.next();
            Path includePath = new Path(includeDir);
            if (!includePath.isPrefixOf(includeFilePath)) continue;
            return true;
        }
        return false;
    }

    private DeclarationFinder searchDeclaration(IASTName funcName) {
        DeclarationFinder findDeclaration = null;
        StringBuffer pattern = new StringBuffer(STRING_QUOTE);
        if (funcName.toString() != null) {
            pattern.append(funcName.toString());
        }
        pattern.append(STRING_QUOTE);
        IASTName[] names = funcName.getTranslationUnit().getDeclarations(funcName.resolveBinding());
        if (names.length > 0) {
            DOMDisplaySearchNames query = new DOMDisplaySearchNames((IASTNode[])names, "Find Declarations", pattern.toString());
            findDeclaration = new DeclarationFinder(query);
            MpiPlugin.getStandardDisplay().syncExec((Runnable)findDeclaration);
        }
        return findDeclaration;
    }

    private SourceInfo getSourceInfo(IASTExpression astExpr, int constructType) {
        SourceInfo sourceInfo = null;
        IASTNodeLocation[] locations = astExpr.getNodeLocations();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
                sourceInfo = new SourceInfo();
                sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                sourceInfo.setStart(astFileLocation.getNodeOffset());
                sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                sourceInfo.setConstructType(constructType);
            }
        }
        return sourceInfo;
    }

    private SourceInfo getSourceInfo(IASTMacroExpansion iASTMacroExpansion) {
        SourceInfo sourceInfo = null;
        IASTFileLocation iASTFileLocation = iASTMacroExpansion.asFileLocation();
        sourceInfo = new SourceInfo();
        sourceInfo.setStartingLine(iASTFileLocation.getStartingLineNumber());
        sourceInfo.setStart(iASTFileLocation.getNodeOffset());
        sourceInfo.setEnd(iASTFileLocation.getNodeOffset() + iASTFileLocation.getNodeLength());
        sourceInfo.setConstructType(2);
        return sourceInfo;
    }

    private boolean preprocessorIncluded(IASTNode astNode) {
        String tuFilePath;
        if (astNode.getFileLocation() == null) {
            return false;
        }
        String location = astNode.getFileLocation().getFileName();
        return !location.equals(tuFilePath = astNode.getTranslationUnit().getFilePath());
    }

    public void processIdExprAsLiteral(IASTIdExpression expression) {
        SourceInfo sourceInfo;
        CSearchResult result;
        IASTName name = expression.getName();
        DeclarationFinder finder = this.searchDeclaration(name);
        if (finder != null && this.isMPICall(result = finder.getResult()) && (sourceInfo = this.getSourceInfo((IASTExpression)expression, 2)) != null) {
            this.scanReturn.addMpiArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, name.toString(), MPI_CONSTANT, sourceInfo));
        }
    }
}

