/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.simulation.ui.preferences;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class SimulationProjectCreation
implements IRunnableContext {
    private final String TEMPLATE_FOLDER = "template";
    private String projectName = "";
    private String fileName = "";

    public SimulationProjectCreation(String projectName, String fileName) {
        this.projectName = projectName;
        this.fileName = fileName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFullFileName() {
        return String.valueOf(this.getFileName()) + this.getFileExtension();
    }

    public abstract String getFileExtension();

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(PTPUIPlugin.getActiveWorkbenchShell()).run(fork, cancelable, runnable);
    }

    public void createSimulatorProject() throws CoreException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Creating simulator project", 10);
                try {
                    try {
                        SimulationProjectCreation.this.createSimulatorProject(SimulationProjectCreation.this.projectName, SimulationProjectCreation.this.fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.subTask("Done..");
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this, runnable, null);
        }
        catch (InterruptedException interruptedException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (InvocationTargetException e1) {
            Throwable innerException = e1.getTargetException();
            if (innerException instanceof CoreException) {
                throw (CoreException)innerException;
            }
            throw new CoreException((IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 0, "Internal error", innerException));
        }
    }

    public boolean isSimulatorProjectExisted() {
        IResource project = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getProjectName());
        if (project == null || !project.exists() || project.getType() != 4) {
            return false;
        }
        IResource file = project.getProject().findMember(this.getFullFileName());
        return file != null && file.exists() && file.getType() == 1;
    }

    private void createSimulatorProject(String projectName, String fileName, IProgressMonitor monitor) throws CoreException {
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.getProjectName());
        if (!project.exists()) {
            IProjectDescription description = workspace.newProjectDescription(project.getName());
            description.setLocation(project.getLocation());
            this.createProject(description, project, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        }
        if (!(file = workspace.getRoot().getFile(project.getFullPath().append(this.getFullFileName()))).exists() || !file.isReadOnly()) {
            this.createFile(file, this.getFileContent(), (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.setReadyOnly((IResource)file);
        }
        this.openEditor(file);
    }

    protected InputStream getFileContent() {
        String templateFile = this.getTemplateFile();
        if (templateFile == null) {
            return null;
        }
        try {
            File file = this.getTemplateFilePath(templateFile).toFile();
            if (file.exists()) {
                return file.toURL().openStream();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    private IPath getTemplateFilePath(String templateFile) {
        String pluginPath = PTPUIPlugin.getDefault().getPluginPath();
        if (pluginPath == null) {
            return null;
        }
        return new Path(pluginPath).append("template").append(templateFile);
    }

    protected abstract String getTemplateFile();

    protected abstract void createProject(IProjectDescription var1, IProject var2, IProgressMonitor var3) throws CoreException;

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                if (!fileHandle.isReadOnly()) {
                    fileHandle.setContents(contents, false, false, monitor);
                }
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void setReadyOnly(IResource resource) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        if (attributes != null) {
            attributes.setReadOnly(true);
            resource.setResourceAttributes(attributes);
        }
    }

    protected abstract String getEditorID();

    protected void openEditor(IFile file) throws CoreException {
        IEditorPart editorPart = this.getEditorPart(file);
        if (editorPart == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        ITextEditor textEditor = this.getTextEditor(editorPart);
        if (textEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        if (docProvider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)docProvider;
            extension.validateState((Object)editorPart.getEditorInput(), null);
        }
    }

    protected IEditorPart getEditorPart(IFile file) {
        IEditorInput editorInput;
        IWorkbenchPage page = PTPUIPlugin.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput && ((IFileEditorInput)editorInput).getFile().equals((Object)file)) {
            page.bringToTop((IWorkbenchPart)editorPart);
            return editorPart;
        }
        IEditorReference[] refs = page.getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            IEditorPart refEditor = refs[i].getEditor(false);
            IEditorInput editorInput2 = refEditor.getEditorInput();
            if (editorInput2 instanceof IFileEditorInput && ((IFileEditorInput)editorInput2).getFile().equals((Object)file)) {
                page.bringToTop((IWorkbenchPart)refEditor);
                return refEditor;
            }
            ++i;
        }
        try {
            return page.openEditor((IEditorInput)new FileEditorInput(file), this.getEditorID(), false);
        }
        catch (PartInitException e) {
            PTPUIPlugin.log((Throwable)e);
            return null;
        }
    }

    protected ITextEditor getTextEditor(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            return (ITextEditor)editorPart;
        }
        return (ITextEditor)editorPart.getAdapter(ITextEditor.class);
    }

    protected IFile getFile(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }
}

