/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.commands.GetAIFCommand;

public class SourceManager
extends Manager {
    public SourceManager(Session session) {
        super(session, false);
    }

    public void update(Target target) throws PCDIException {
    }

    public void shutdown() {
    }

    public IAIF getDetailAIFFromVariable(StackFrame frame, String name) throws PCDIException {
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
        try {
            IAIF iAIF = this.getAIF(target, name);
            return iAIF;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
        }
    }

    public IAIF getAIF(Target target, String name) throws PCDIException {
        GetAIFCommand command = new GetAIFCommand(target.getTask(), name);
        target.getDebugger().postCommand((IDebugCommand)command);
        return command.getAIF();
    }

    public void setSourcePaths(Target target, String[] dirs) throws PCDIException {
        throw new PCDIException(" SourceManager - setSourcePaths not implemented yet");
    }

    public String[] getSourcePaths(Target target) throws PCDIException {
        throw new PCDIException(" SourceManager - getSourcePaths not implemented yet");
    }
}

