/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model.variable;

import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.aif.ITypeAggregate;
import org.eclipse.ptp.debug.core.aif.ITypeDerived;
import org.eclipse.ptp.debug.core.aif.IValueAggregate;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.ExpressionManager;
import org.eclipse.ptp.debug.external.core.cdi.MemoryManager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.event.VarChangedEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.VariableDescriptor;
import org.eclipse.ptp.debug.external.core.commands.GetPartialAIFCommand;

public abstract class Variable
extends VariableDescriptor
implements IPCDIVariable {
    public IPCDIVariable[] children = new IPCDIVariable[0];
    String editable = null;
    String language;
    boolean isFake = false;
    boolean isUpdated = true;

    public Variable(VariableDescriptor obj) {
        super(obj);
    }

    public Variable(Target target, Thread thread, StackFrame frame, String name, String fullName, int pos, int depth, String keyName) {
        super(target, thread, frame, name, fullName, pos, depth);
        this.keyName = keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setUpdated(boolean update) {
        this.isUpdated = update;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public Variable getChild(String name) {
        int i = 0;
        while (i < this.children.length) {
            Variable var = (Variable)this.children[i];
            try {
                if (name.equals(var.getKeyName())) {
                    return var;
                }
                Variable grandChild = var.getChild(name);
                if (grandChild != null) {
                    return grandChild;
                }
            }
            catch (PCDIException pCDIException) {}
            ++i;
        }
        return null;
    }

    void setIsFake(boolean f) {
        this.isFake = f;
    }

    boolean isFake() {
        return this.isFake;
    }

    public String getKeyName() throws PCDIException {
        if (this.keyName == null) {
            throw new PCDIException("No key name found");
        }
        return this.keyName;
    }

    public IPCDIVariable[] getChildren() throws PCDIException {
        String key = this.keyName;
        String fn = this.getFullName();
        boolean childFake = false;
        Target target = (Target)this.getTarget();
        GetPartialAIFCommand command = new GetPartialAIFCommand(target.getTask(), this.getQualifiedName(), key, true);
        target.getDebugger().postCommand((IDebugCommand)command);
        IAIF aif = command.getPartialAIF();
        String ch_key = command.getName();
        IAIFType type = aif.getType();
        IAIFValue value = aif.getValue();
        this.fTypename = aif.getDescription();
        if (key == null) {
            key = this.keyName = ch_key;
        }
        if (type instanceof ITypeDerived) {
            IAIFType baseType = ((ITypeDerived)type).getBaseType();
            if (type instanceof IAIFTypeArray) {
                IAIFValue[] values = ((IAIFValueArray)value).getValues();
                this.children = new Variable[values.length];
                int i = 0;
                while (i < this.children.length) {
                    int index = this.castingIndex + i;
                    String ch_fn = "(" + fn + ")[" + index + "]";
                    String ch_n = String.valueOf(this.getName()) + "[" + index + "]";
                    String ch_k = String.valueOf(key) + "." + i;
                    Variable v = this.createVariable((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                    v.setIsFake(childFake);
                    v.fType = baseType;
                    v.fValue = values[i];
                    this.children[i] = v;
                    ++i;
                }
            } else if (type instanceof IAIFTypePointer) {
                if (baseType instanceof ITypeAggregate) {
                    ITypeAggregate aggrType = (ITypeAggregate)baseType;
                    this.children = new Variable[aggrType.getNumberOfChildren()];
                    int i = 0;
                    while (i < this.children.length) {
                        String ch_fn = "(" + fn + ")->" + aggrType.getField(i);
                        String ch_n = aggrType.getField(i);
                        String ch_k = String.valueOf(key) + "." + ch_n;
                        Variable v = this.createVariable((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                        v.setIsFake(childFake);
                        v.fType = aggrType.getType(i);
                        v.fValue = ((IValueAggregate)value).getValue(i);
                        this.children[i] = v;
                        ++i;
                    }
                } else {
                    this.children = new Variable[1];
                    String ch_fn = "*(" + fn + ")";
                    String ch_n = ch_key;
                    String ch_k = String.valueOf(key) + "." + ch_key;
                    Variable v = this.createVariable((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                    v.setIsFake(childFake);
                    v.fType = type;
                    v.fValue = value;
                    this.children[0] = v;
                }
            }
        } else if (type instanceof IAIFTypeReference) {
            this.children = new Variable[1];
            String ch_fn = "(" + fn + ")->" + ((IAIFTypeReference)type).getName();
            String ch_n = ((IAIFTypeReference)type).getName();
            String ch_k = String.valueOf(key) + "." + ch_n;
            Variable v = this.createVariable((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
            v.setIsFake(childFake);
            v.fType = type;
            v.fValue = value;
            this.children[0] = v;
        } else if (type instanceof ITypeAggregate) {
            ITypeAggregate aggrType = (ITypeAggregate)type;
            this.children = new Variable[aggrType.getNumberOfChildren()];
            int i = 0;
            while (i < this.children.length) {
                String ch_fn = "(" + fn + ")." + aggrType.getField(i);
                String ch_n = aggrType.getField(i);
                String ch_k = String.valueOf(key) + "." + ch_n;
                Variable v = this.createVariable((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
                v.setIsFake(childFake);
                v.fType = aggrType.getType(i);
                v.fValue = ((IValueAggregate)value).getValue(i);
                this.children[i] = v;
                ++i;
            }
        } else {
            this.children = new Variable[1];
            String ch_fn = fn;
            String ch_n = ch_key;
            String ch_k = String.valueOf(key) + "." + ch_key;
            Variable v = this.createVariable((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), ch_n, ch_fn, this.getPosition(), this.getStackDepth(), ch_k);
            v.setIsFake(childFake);
            v.fType = type;
            v.fValue = value;
            this.children[0] = v;
        }
        return this.children;
    }

    protected abstract Variable createVariable(Target var1, Thread var2, StackFrame var3, String var4, String var5, int var6, int var7, String var8);

    public int getChildrenNumber() throws PCDIException {
        IAIFType t = this.getType();
        if (t instanceof IAIFTypeArray) {
            return ((IAIFTypeArray)t).getRange();
        }
        if (t instanceof ITypeAggregate) {
            return ((ITypeAggregate)t).getNumberOfChildren();
        }
        return 0;
    }

    public IAIFValue getValue() throws PCDIException {
        if (this.fValue == null || this.fValue == AIFFactory.UNKNOWNVALUE) {
            Target target = (Target)this.getTarget();
            GetPartialAIFCommand command = new GetPartialAIFCommand(this.getTarget().getTask(), this.getQualifiedName(), this.getKeyName(), false, true);
            target.getDebugger().postCommand((IDebugCommand)command);
            IAIF aif = command.getPartialAIF();
            this.fType = aif.getType();
            this.fValue = aif.getValue();
            this.fTypename = aif.getDescription();
            this.keyName = command.getName();
        }
        return this.fValue;
    }

    public void resetValue() {
        this.fValue = null;
    }

    public void setValue(IAIFValue fValue) throws PCDIException {
        try {
            this.setValue(fValue.getValueString());
        }
        catch (AIFException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public void setValue(String expression) throws PCDIException {
        MemoryManager memMgr;
        VariableManager varMgr;
        Target target = (Target)this.getTarget();
        target.getDebugger().fireEvent((IPCDIEvent)new VarChangedEvent(target.getSession(), target.getTask(), this, this.getKeyName()));
        ExpressionManager expMgr = ((Session)target.getSession()).getExpressionManager();
        if (expMgr.isAutoUpdate()) {
            expMgr.update(target);
        }
        if ((varMgr = ((Session)target.getSession()).getVariableManager()).isAutoUpdate()) {
            varMgr.update(target);
        }
        if ((memMgr = ((Session)target.getSession()).getMemoryManager()).isAutoUpdate()) {
            memMgr.update(target);
        }
        throw new PCDIException("Not implemented yet - Variable: setValue -- value assgin");
    }

    public boolean isEditable() throws PCDIException {
        if (this.editable == null) {
            throw new PCDIException("Not implement yet - Variable: isEditable");
        }
        return this.editable == null ? false : this.editable.equalsIgnoreCase("true");
    }

    public void setFormat(int format) throws PCDIException {
        throw new PCDIException("Not implement yet - Variable: setFormat");
    }

    public boolean equals(IPCDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return this.equals(variable);
        }
        return super.equals((IPCDIVariableDescriptor)var);
    }

    public boolean equals(Variable variable) {
        try {
            return this.getKeyName().equals(variable.getKeyName());
        }
        catch (PCDIException pCDIException) {
            return super.equals(variable);
        }
    }

    public void dispose() throws PCDIException {
        IPCDITarget target = this.getTarget();
        VariableManager varMgr = ((Session)target.getSession()).getVariableManager();
        varMgr.destroyVariable(this);
    }

    public String getTypeName() throws PCDIException {
        return this.getType().toString();
    }

    public IPCDIVariable[] getChildren(int findex, int psize) throws PCDIException {
        IPCDITarget target = this.getTarget();
        VariableManager varMgr = ((Session)target.getSession()).getVariableManager();
        VariableDescriptor vo = varMgr.getVariableDescriptorAsArray(this, findex, psize);
        Variable var = varMgr.createVariable(vo);
        return var.getChildren();
    }
}

