/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.cdi.model.DataReadMemoryInfo;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public class DataReadMemoryCommand
extends AbstractDebugCommand {
    long offset;
    String address;
    int wordFormat;
    int wordSize;
    int rows;
    int cols;
    Character asChar;

    public DataReadMemoryCommand(BitList tasks, long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) {
        super(tasks);
        this.offset = offset;
        this.address = address;
        this.wordFormat = wordFormat;
        this.wordSize = wordSize;
        this.rows = rows;
        this.cols = cols;
        this.asChar = asChar;
    }

    public void preExecCommand(IAbstractDebugger debugger) throws PCDIException {
        this.exec(debugger);
    }

    public void exec(IAbstractDebugger debugger) throws PCDIException {
        debugger.setDataReadMemoryCommand(this.tasks, this.offset, this.address, this.wordFormat, this.wordSize, this.rows, this.cols, this.asChar);
    }

    public DataReadMemoryInfo getDataReadMemoryInfo() throws PCDIException {
        Object res = this.getResultValue();
        if (res instanceof DataReadMemoryInfo) {
            return (DataReadMemoryInfo)res;
        }
        return null;
    }

    public String getCommandName() {
        return "Data Read Memory";
    }
}

