/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public class ListArgumentsCommand
extends AbstractDebugCommand {
    int low = 0;
    int high = 0;

    public ListArgumentsCommand(BitList tasks, int low, int high) {
        super(tasks);
        this.low = low;
        this.high = high;
    }

    public void preExecCommand(IAbstractDebugger debugger) throws PCDIException {
        this.checkBeforeExecCommand(debugger);
    }

    public void exec(IAbstractDebugger debugger) throws PCDIException {
        debugger.listArguments(this.tasks, this.low, this.high);
    }

    public String[] getArguments() throws PCDIException {
        Object res = this.getResultValue();
        if (res instanceof String[]) {
            return (String[])res;
        }
        return new String[0];
    }

    public String getCommandName() {
        return "List arguments";
    }
}

