/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public class TerminateCommand
extends AbstractDebugCommand {
    private boolean sendEvent = true;

    public TerminateCommand(BitList tasks, boolean sendEvent) {
        super(tasks, true, true, false);
        this.setPriority(3);
        this.sendEvent = sendEvent;
    }

    public TerminateCommand(BitList tasks) {
        this(tasks, true);
    }

    public void preExecCommand(IAbstractDebugger debugger) throws PCDIException {
        debugger.filterTerminateTasks(this.tasks);
        if (!this.tasks.isEmpty()) {
            this.suspendRunningTasks(debugger);
            this.exec(debugger);
            if (this.waitForReturn() && this.sendEvent) {
                debugger.handleProcessTerminatedEvent(this.tasks, 0);
            }
        } else {
            this.doCancelWaiting();
        }
    }

    public void exec(IAbstractDebugger debugger) throws PCDIException {
        debugger.kill(this.tasks);
    }

    public String getCommandName() {
        return "Terminate";
    }
}

