/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.debugger;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.IDebugger;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILineBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIWatchpoint;
import org.eclipse.ptp.debug.external.core.AbstractDebugger;
import org.eclipse.ptp.debug.external.core.cdi.model.Signal;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugClient;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugSignal;
import org.eclipse.ptp.debug.external.core.proxy.event.IProxyDebugEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.IProxyDebugEventListener;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugArgsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugDataEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugDataExpValueEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugErrorEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugExitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugInfoThreadsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugInitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugMemoryInfoEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugPartialAIFEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSetThreadSelectEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalExitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStackInfoDepthEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStackframeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStepEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSuspendEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugTypeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugVarsEvent;

public class ParallelDebugger
extends AbstractDebugger
implements IDebugger,
IProxyDebugEventListener {
    private ProxyDebugClient proxy;
    private int bpId = 0;

    public int getDebuggerPort() throws CoreException {
        this.proxy = new ProxyDebugClient();
        try {
            this.proxy.sessionCreate();
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, "could not create proxy", null));
        }
        return this.proxy.getSessionPort();
    }

    public void connection(IProgressMonitor monitor) throws CoreException {
        try {
            if (this.proxy.waitForConnect(monitor)) {
                this.proxy.addEventListener(this);
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void disconnection(IProgressMonitor monitor) throws CoreException {
        try {
            try {
                if (this.proxy != null) {
                    this.proxy.removeEventListener(this);
                    this.proxy.closeConnection();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
        finally {
            this.proxy = null;
        }
    }

    public void startDebugger(IPJob job) throws CoreException {
        try {
            String app = (String)job.getAttribute("app_name");
            String path = (String)job.getAttribute("app_path");
            String dir = (String)job.getAttribute("work_dir");
            String[] args = (String[])job.getAttribute("args");
            this.proxy.debugStartSession(app, path, dir, args);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stopDebugger() throws CoreException {
        if (this.proxy != null) {
            try {
                this.proxy.sessionFinish();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
    }

    public Process getDebuggerProcess() {
        return null;
    }

    public void restart() throws PCDIException {
        throw new PCDIException("<Not implemented>", "restart");
    }

    public void run(String[] args) throws PCDIException {
        throw new PCDIException("<Not implemented>", "run");
    }

    public void go(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugGo(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void kill(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugTerminate(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void halt(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugInterrupt(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void stepInto(BitList tasks, int count) throws PCDIException {
        try {
            this.proxy.debugStep(tasks, count, 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void stepOver(BitList tasks, int count) throws PCDIException {
        try {
            this.proxy.debugStep(tasks, count, 1);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void stepFinish(BitList tasks, int count) throws PCDIException {
        try {
            this.proxy.debugStep(tasks, count, 2);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setLineBreakpoint(BitList tasks, IPCDILineBreakpoint bpt) throws PCDIException {
        try {
            IPCDICondition condition = bpt.getCondition();
            this.proxy.debugSetLineBreakpoint(tasks, this.newBreakpointId(), bpt.isTemporary(), bpt.isHardware(), bpt.getLocator().getFile(), bpt.getLocator().getLineNumber(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setFunctionBreakpoint(BitList tasks, IPCDIFunctionBreakpoint bpt) throws PCDIException {
        try {
            IPCDICondition condition = bpt.getCondition();
            this.proxy.debugSetFuncBreakpoint(tasks, this.newBreakpointId(), bpt.isTemporary(), bpt.isHardware(), bpt.getLocator().getFile(), bpt.getLocator().getFunction(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setWatchpoint(BitList tasks, IPCDIWatchpoint bpt) throws PCDIException {
        try {
            String expression = bpt.getWatchExpression();
            boolean access = bpt.isReadType() && bpt.isWriteType();
            boolean read = !bpt.isWriteType() && bpt.isReadType();
            IPCDICondition condition = bpt.getCondition();
            this.proxy.debugSetWatchpoint(tasks, this.newBreakpointId(), expression, access, read, condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void deleteBreakpoint(BitList tasks, int bpid) throws PCDIException {
        try {
            this.proxy.debugDeleteBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void enableBreakpoint(BitList tasks, int bpid) throws PCDIException {
        try {
            this.proxy.debugEnableBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void disableBreakpoint(BitList tasks, int bpid) throws PCDIException {
        try {
            this.proxy.debugDisableBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void conditionBreakpoint(BitList tasks, int bpid, String expr) throws PCDIException {
        try {
            this.proxy.debugConditionBreakpoint(tasks, bpid, expr);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void listStackFrames(BitList tasks, int low, int high) throws PCDIException {
        try {
            this.proxy.debugListStackframes(tasks, low, high);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setCurrentStackFrame(BitList tasks, int level) throws PCDIException {
        try {
            this.proxy.debugSetCurrentStackframe(tasks, level);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void evaluateExpression(BitList tasks, String expr) throws PCDIException {
        try {
            this.proxy.debugEvaluateExpression(tasks, expr);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void getAIF(BitList tasks, String expr) throws PCDIException {
        this.evaluateExpression(tasks, expr);
    }

    public void getVariableType(BitList tasks, String varName) throws PCDIException {
        try {
            this.proxy.debugGetType(tasks, varName);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void listLocalVariables(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugListLocalVariables(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void listGlobalVariables(BitList tasks) throws PCDIException {
        throw new PCDIException("<Not implemented>", "listGlobalVariables");
    }

    public void listArguments(BitList tasks, int low, int high) throws PCDIException {
        try {
            this.proxy.debugListArguments(tasks, low, high);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void getInfothreads(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugListInfoThreads(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setThreadSelect(BitList tasks, int threadNum) throws PCDIException {
        try {
            this.proxy.debugSetThreadSelect(tasks, threadNum);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    private String createFormat(int wordFormat) {
        switch (wordFormat) {
            case 15: {
                return "u";
            }
            case 10: {
                return "f";
            }
            case 11: {
                return "a";
            }
            case 12: {
                return "i";
            }
            case 13: {
                return "c";
            }
            case 14: {
                return "s";
            }
            case 3: {
                return "d";
            }
            case 2: {
                return "t";
            }
            case 1: {
                return "o";
            }
        }
        return "x";
    }

    public void setDataReadMemoryCommand(BitList tasks, long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) throws PCDIException {
        try {
            this.proxy.setDataReadMemoryCommand(tasks, offset, address, this.createFormat(wordFormat), wordSize, rows, cols, asChar);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setDataWriteMemoryCommand(BitList tasks, long offset, String address, int wordFormat, int wordSize, String value) throws PCDIException {
        try {
            this.proxy.setDataWriteMemoryCommand(tasks, offset, address, this.createFormat(wordFormat), wordSize, value);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void getStackInfoDepth(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugStackInfoDepth(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void getListSignals(BitList tasks, String name) throws PCDIException {
        try {
            this.proxy.debugListSignals(tasks, name);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void getSignalInfo(BitList tasks, String arg) throws PCDIException {
        try {
            this.proxy.debugSignalInfo(tasks, arg);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void cliHandle(BitList tasks, String arg) throws PCDIException {
        try {
            this.proxy.debugCLIHandle(tasks, arg);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void dataEvaluateExpression(BitList tasks, String expression) throws PCDIException {
        try {
            this.proxy.debugDataEvaluateExpression(tasks, expression);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void getPartialAIF(BitList tasks, String expr, String key, boolean listChildren, boolean express) throws PCDIException {
        try {
            this.proxy.debugGetPartialAIF(tasks, expr, key, listChildren, express);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void variableDelete(BitList tasks, String varname) throws PCDIException {
        try {
            this.proxy.debugVariableDelete(tasks, varname);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    protected int getErrorCode(int internalErrorCode) {
        switch (internalErrorCode) {
            case 4: 
            case 5: 
            case 26: 
            case 33: {
                return 2;
            }
            case 12: 
            case 13: 
            case 38: 
            case 39: {
                return 0;
            }
        }
        return 1;
    }

    public synchronized void handleEvent(IProxyDebugEvent e) {
        PDebugUtils.println((String)("got debug event: " + e.toString()));
        switch (e.getEventID()) {
            case 111: {
                this.completeCommand(e.getBitSet(), "OK");
                break;
            }
            case 110: {
                int numServers = ((ProxyDebugInitEvent)e).getNumServers();
                PDebugUtils.println((String)("num servers = " + numServers));
                this.completeCommand(e.getBitSet(), "OK");
                break;
            }
            case 112: {
                ProxyDebugErrorEvent errEvent = (ProxyDebugErrorEvent)e;
                String errMsg = errEvent.getErrorMessage();
                if (errMsg == null || errMsg.length() == 0) {
                    errMsg = "Unknown Error";
                }
                int err_code = this.getErrorCode(errEvent.getErrorCode());
                this.completeCommand(e.getBitSet(), (Object)new PCDIException(errMsg, err_code));
                break;
            }
            case 113: {
                if (e instanceof ProxyDebugBreakpointHitEvent) {
                    ProxyDebugBreakpointHitEvent bptHitEvent = (ProxyDebugBreakpointHitEvent)e;
                    this.handleBreakpointHitEvent(e.getBitSet(), bptHitEvent.getBreakpointId(), bptHitEvent.getThreadId(), bptHitEvent.getChangedVars());
                    break;
                }
                if (e instanceof ProxyDebugSuspendEvent) {
                    ProxyDebugSuspendEvent suspendEvent = (ProxyDebugSuspendEvent)e;
                    this.handleSuspendEvent(e.getBitSet(), suspendEvent.getLocator(), suspendEvent.getThreadId(), suspendEvent.getChangedVars());
                    break;
                }
                if (e instanceof ProxyDebugStepEvent) {
                    ProxyDebugStepEvent stepEvent = (ProxyDebugStepEvent)e;
                    this.handleEndSteppingEvent(e.getBitSet(), stepEvent.getFrame().getLocator().getLineNumber(), stepEvent.getFrame().getLocator().getFile(), stepEvent.getThreadId(), stepEvent.getChangedVars());
                    break;
                }
                if (!(e instanceof ProxyDebugSignalEvent)) break;
                ProxyDebugSignalEvent sigEvent = (ProxyDebugSignalEvent)e;
                IDebugCommand cmd = this.getInterruptCommand();
                if (cmd != null) {
                    cmd.setReturn(e.getBitSet(), (Object)"OK");
                    break;
                }
                this.handleProcessSignaledEvent(e.getBitSet(), sigEvent.getLocator(), sigEvent.getThreadId(), sigEvent.getChangedVars());
                break;
            }
            case 104: {
                this.completeCommand(e.getBitSet(), ((ProxyDebugBreakpointSetEvent)e).getBreakpoint());
                break;
            }
            case 105: {
                this.completeCommand(e.getBitSet(), ((ProxyDebugStackframeEvent)e).getFrames());
                break;
            }
            case 107: {
                this.completeCommand(e.getBitSet(), ((ProxyDebugTypeEvent)e).getType());
                break;
            }
            case 106: {
                this.completeCommand(e.getBitSet(), ((ProxyDebugDataEvent)e).getData());
                break;
            }
            case 108: {
                this.completeCommand(e.getBitSet(), ((ProxyDebugVarsEvent)e).getVariables());
                break;
            }
            case 109: {
                this.completeCommand(e.getBitSet(), ((ProxyDebugArgsEvent)e).getVariables());
                break;
            }
            case 1: {
                PDebugUtils.println((String)"======================= EVENT_DBG_EXIT_SIGNAL ====================");
                ProxyDebugSignalExitEvent exitSigEvent = (ProxyDebugSignalExitEvent)e;
                this.handleProcessTerminatedEvent(e.getBitSet(), exitSigEvent.getSignalName(), exitSigEvent.getSignalMeaning());
                break;
            }
            case 102: {
                PDebugUtils.println((String)"======================= EVENT_DBG_EXIT ====================");
                ProxyDebugExitEvent exitEvent = (ProxyDebugExitEvent)e;
                this.handleProcessTerminatedEvent(e.getBitSet(), exitEvent.getExitStatus());
                break;
            }
            case 119: {
                ProxyDebugSignalsEvent signalsEvent = (ProxyDebugSignalsEvent)e;
                IPCDISignal[] pcdiSignals = new IPCDISignal[]{};
                IPProcess[] sigProcs = this.getProcesses(e.getBitSet());
                if (sigProcs.length > 0) {
                    int taskId = sigProcs[0].getTaskId();
                    IPCDITarget target = this.getSession().getTarget(taskId);
                    ProxyDebugSignal[] signals = signalsEvent.getSignals();
                    pcdiSignals = new IPCDISignal[signals.length];
                    int j = 0;
                    while (j < signals.length) {
                        pcdiSignals[j] = new Signal((Target)target, signals[j].getName(), signals[j].isStop(), signals[j].isPrint(), signals[j].isPass(), signals[j].getDescription());
                        ++j;
                    }
                }
                this.completeCommand(e.getBitSet(), pcdiSignals);
                break;
            }
            case 114: {
                this.completeCommand(e.getBitSet(), ((ProxyDebugInfoThreadsEvent)e).getThreadIds());
                break;
            }
            case 115: {
                ProxyDebugSetThreadSelectEvent setThreadSelectEvent = (ProxyDebugSetThreadSelectEvent)e;
                Object[] objects = new Object[]{new Integer(setThreadSelectEvent.getThreadId()), setThreadSelectEvent.getFrame()};
                this.completeCommand(e.getBitSet(), objects);
                break;
            }
            case 116: {
                ProxyDebugStackInfoDepthEvent stackInfoDepthEvent = (ProxyDebugStackInfoDepthEvent)e;
                this.completeCommand(e.getBitSet(), new Integer(stackInfoDepthEvent.getDepth()));
                break;
            }
            case 117: {
                ProxyDebugMemoryInfoEvent memoryInfoEvent = (ProxyDebugMemoryInfoEvent)e;
                this.completeCommand(e.getBitSet(), memoryInfoEvent.getMemoryInfo());
                break;
            }
            case 120: {
                this.completeCommand(e.getBitSet(), (ProxyDebugDataExpValueEvent)e);
                break;
            }
            case 121: {
                this.completeCommand(e.getBitSet(), (ProxyDebugPartialAIFEvent)e);
            }
        }
    }

    private int newBreakpointId() {
        return this.bpId++;
    }
}

