/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.simulator2;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IDebugger;
import org.eclipse.ptp.debug.core.aif.AIF;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgument;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILineBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIWatchpoint;
import org.eclipse.ptp.debug.external.core.AbstractDebugger;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.LineBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.model.LineLocation;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Argument;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariable;
import org.eclipse.ptp.debug.external.core.simulator2.InternalEventQueue;
import org.eclipse.ptp.debug.external.core.simulator2.QueueItem;
import org.eclipse.ptp.debug.external.core.simulator2.SimulateFrame;
import org.eclipse.ptp.debug.external.core.simulator2.SimulateProgram;

public class DebugSimulation2
extends AbstractDebugger
implements IDebugger,
Observer {
    public static final String HIT_BPT_STATE = "HIT_BPT";
    public static final String EXIT_STATE = "EXIT";
    public static final String STEP_END_STATE = "STEP_END";
    private static final String APP_NAME = "../main.c";
    private final boolean EVENT_BY_EACH_PROC = false;
    private List sim_list = new ArrayList();
    private final long TIME_RANGE = 100L;
    private int total_process = 0;
    private InternalEventQueue intQueue = null;
    private Map variables = new HashMap();
    private Map arguments = new HashMap();
    private IPCDIStackFrame current_frame = null;
    private int bpt_id = 0;

    public DebugSimulation2() {
        this.intQueue = new InternalEventQueue(100L);
        this.intQueue.addObserver(this);
        this.createArguments();
        this.createVariables();
    }

    public int getBreakpointId() {
        return this.bpt_id++;
    }

    public void connection(IProgressMonitor monitor) throws CoreException {
        this.completeCommand(null, "OK");
    }

    public void disconnection(IProgressMonitor monitor) throws CoreException {
    }

    public int getDebuggerPort() throws CoreException {
        return 0;
    }

    private void createArguments() {
        this.arguments.put("argc", new SimVariable("argc", "char **", ""));
        this.arguments.put("argv", new SimVariable("argv", "int", "-"));
    }

    private void createVariables() {
        this.variables.put("name", new SimVariable("name", "string", "hello"));
        this.variables.put("number", new SimVariable("number", "boolean", "-1"));
    }

    private SimVariable findVariable(String name) {
        return (SimVariable)this.variables.get(name);
    }

    private SimVariable findArgument(String name) {
        return (SimVariable)this.arguments.get(name);
    }

    private SimVariable[] getArguments() {
        return this.arguments.values().toArray(new SimVariable[0]);
    }

    private SimVariable[] getVariables() {
        return this.variables.values().toArray(new SimVariable[0]);
    }

    public void startDebugger(final IPJob job) {
        new java.lang.Thread(new Runnable(){

            public void run() {
                DebugSimulation2.this.total_process = job.totalProcesses();
                int i = 0;
                while (i < DebugSimulation2.this.total_process) {
                    SimulateProgram sim_program = new SimulateProgram(i, DebugSimulation2.APP_NAME);
                    sim_program.addObserver(DebugSimulation2.this);
                    DebugSimulation2.this.sim_list.add(sim_program);
                    sim_program.startProgram();
                    ++i;
                }
                DebugSimulation2.this.intQueue.startTimer();
                DebugSimulation2.this.completeCommand(null, "OK");
            }
        }).start();
    }

    public void stopDebugger() throws CoreException {
        if (this.sim_list.isEmpty()) {
            return;
        }
        new java.lang.Thread(new Runnable(){

            public void run() {
                DebugSimulation2.this.intQueue.stopTimer();
                for (SimulateProgram sim_program : DebugSimulation2.this.sim_list) {
                    sim_program.deleteObservers();
                }
                DebugSimulation2.this.intQueue.deleteObservers();
                DebugSimulation2.this.sim_list.clear();
                DebugSimulation2.this.completeCommand(null, "OK");
            }
        }).start();
    }

    public Process getDebuggerProcess() {
        return null;
    }

    public void restart() throws PCDIException {
        throw new PCDIException("<Not implemented>", "restart");
    }

    public void run(String[] args) throws PCDIException {
        throw new PCDIException("<Not implemented>", "run");
    }

    public void deleteBreakpoint(final BitList tasks, final int bpid) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).deleteBpt(bpid);
                    ++i;
                }
            }
        }).start();
    }

    public void getAIF(final BitList tasks, final String expr) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                AIF aif = null;
                SimVariable variable = DebugSimulation2.this.findVariable(expr);
                if (variable == null) {
                    variable = DebugSimulation2.this.findArgument(expr);
                }
                if (variable == null) {
                    aif = new AIF("unknown", new byte[0]);
                }
                if (aif == null) {
                    String value = "" + DebugSimulation2.random(10, 20);
                    aif = new AIF("b", value.getBytes());
                }
                DebugSimulation2.this.completeCommand(tasks, aif);
            }
        }).start();
    }

    public void go(final BitList tasks) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).go();
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, "OK");
            }
        }).start();
    }

    public void kill(final BitList tasks) throws PCDIException {
        this.halt(tasks);
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).stopProgram();
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, "OK");
            }
        }).start();
    }

    public void halt(final BitList tasks) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).suspend();
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, "OK");
            }
        }).start();
    }

    public void stepInto(final BitList tasks, int count) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).stepLine();
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, "OK");
            }
        }).start();
    }

    public void stepOver(final BitList tasks, int count) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).stepOverLine();
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, "OK");
            }
        }).start();
    }

    public void stepFinish(final BitList tasks, int count) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).stepFinish();
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, "OK");
            }
        }).start();
    }

    public void setLineBreakpoint(final BitList tasks, final IPCDILineBreakpoint bpt) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int line = bpt.getLocator().getLineNumber();
                IPCDIBreakpoint new_bpt = DebugSimulation2.this.createBreakpoint(bpt.getLocator().getFile(), line, (IPCDIBreakpoint)bpt);
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).setBpt(line, new_bpt.getBreakpointId());
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, new_bpt);
            }
        }).start();
    }

    public void enableBreakpoint(BitList tasks, int bpid) throws PCDIException {
    }

    public void disableBreakpoint(BitList tasks, int bpid) throws PCDIException {
    }

    public void conditionBreakpoint(BitList tasks, int bpid, String expr) throws PCDIException {
    }

    public void getListSignals(BitList tasks, String name) throws PCDIException {
    }

    public void getSignalInfo(BitList tasks, String arg) throws PCDIException {
    }

    public void cliHandle(BitList tasks, String arg) throws PCDIException {
    }

    public void setFunctionBreakpoint(final BitList tasks, final IPCDIFunctionBreakpoint bpt) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                int line = 6;
                IPCDIBreakpoint new_bpt = DebugSimulation2.this.createBreakpoint(bpt.getLocator().getFile(), line, (IPCDIBreakpoint)bpt);
                int i = 0;
                while (i < taskArray.length) {
                    DebugSimulation2.this.getSimProg(taskArray[i]).setStopInMain(line, new_bpt.getBreakpointId());
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, new_bpt);
            }
        }).start();
    }

    public void setWatchpoint(BitList tasks, IPCDIWatchpoint bpt) throws PCDIException {
        throw new PCDIException("<Not implemented>", "setWatchpoint");
    }

    private IPCDIBreakpoint createBreakpoint(String file, int line, IPCDIBreakpoint oldBpt) {
        try {
            LineBreakpoint bpt = new LineBreakpoint(oldBpt.getType(), new LineLocation(file, line), oldBpt.getCondition());
            bpt.setBreakpointId(this.getBreakpointId());
            return bpt;
        }
        catch (PCDIException pCDIException) {
            return null;
        }
    }

    public void listStackFrames(final BitList tasks, int low, int high) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                ArrayList<StackFrame> frameList = new ArrayList<StackFrame>();
                int i = 0;
                while (i < taskArray.length) {
                    IPCDITarget target = DebugSimulation2.this.getSession().getTarget(taskArray[i]);
                    try {
                        Thread t = (Thread)target.getCurrentThread();
                        SimulateFrame[] frames = DebugSimulation2.this.getSimProg(taskArray[i]).getSimStackFrames();
                        int j = 0;
                        while (j < frames.length) {
                            frameList.add(new StackFrame(t, frames[j].getLevel(), frames[j].getFile(), frames[j].getFunc(), frames[j].getLine(), new BigInteger(frames[j].getAddr()), null));
                            ++j;
                        }
                    }
                    catch (PCDIException pCDIException) {}
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, frameList.toArray(new IPCDIStackFrame[0]));
            }
        }).start();
    }

    public void setCurrentStackFrame(final BitList tasks, int level) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                DebugSimulation2.this.completeCommand(tasks, "OK");
            }
        }).start();
    }

    public void evaluateExpression(final BitList tasks, final String expression) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                SimVariable variable = DebugSimulation2.this.findVariable(expression);
                if (variable == null) {
                    variable = DebugSimulation2.this.findArgument(expression);
                }
                if (variable == null) {
                    DebugSimulation2.this.completeCommand(tasks, null);
                } else {
                    DebugSimulation2.this.completeCommand(tasks, variable.getValue());
                }
            }
        }).start();
    }

    public void getVariableType(final BitList tasks, final String varName) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                SimVariable variable = DebugSimulation2.this.findVariable(varName);
                if (variable == null) {
                    variable = DebugSimulation2.this.findArgument(varName);
                }
                if (variable == null) {
                    DebugSimulation2.this.completeCommand(tasks, null);
                } else {
                    DebugSimulation2.this.completeCommand(tasks, variable.getType());
                }
            }
        }).start();
    }

    public void listArguments(final BitList tasks, int low, int high) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                ArrayList<Argument> argList = new ArrayList<Argument>();
                int i = 0;
                while (i < taskArray.length) {
                    IPCDITarget target = DebugSimulation2.this.getSession().getTarget(taskArray[i]);
                    SimVariable[] args = DebugSimulation2.this.getArguments();
                    int j = 0;
                    while (j < args.length) {
                        argList.add(new Argument((Target)target, null, (StackFrame)DebugSimulation2.this.current_frame, args[j].getVariable(), args[j].getVariable(), args.length - j, 1, null));
                        ++j;
                    }
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, argList.toArray(new IPCDIArgument[0]));
            }
        }).start();
    }

    public void listLocalVariables(final BitList tasks) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                int[] taskArray = tasks.toArray();
                ArrayList<LocalVariable> varList = new ArrayList<LocalVariable>();
                int i = 0;
                while (i < taskArray.length) {
                    IPCDITarget target = DebugSimulation2.this.getSession().getTarget(taskArray[i]);
                    SimVariable[] vars = DebugSimulation2.this.getVariables();
                    int j = 0;
                    while (j < vars.length) {
                        varList.add(new LocalVariable((Target)target, null, (StackFrame)DebugSimulation2.this.current_frame, vars[j].getVariable(), vars[j].getVariable(), vars.length - j, 1, null));
                        ++j;
                    }
                    ++i;
                }
                DebugSimulation2.this.completeCommand(tasks, varList.toArray(new IPCDILocalVariable[0]));
            }
        }).start();
    }

    public void listGlobalVariables(BitList tasks) throws PCDIException {
        this.completeCommand(tasks, null);
        this.handleErrorEvent(tasks, "<Not implemented> - listGlobalVariables", 2);
    }

    public void getInfothreads(final BitList tasks) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                DebugSimulation2.this.completeCommand(tasks, new String[]{"0"});
            }
        }).start();
    }

    public void setThreadSelect(final BitList tasks, final int threadNum) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                DebugSimulation2.this.completeCommand(tasks, new Object[]{new Integer(threadNum)});
            }
        }).start();
    }

    public void getStackInfoDepth(final BitList tasks) throws PCDIException {
        new java.lang.Thread(new Runnable(){

            public void run() {
                DebugSimulation2.this.completeCommand(tasks, new Integer(1));
            }
        }).start();
    }

    public void setDataReadMemoryCommand(BitList tasks, long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) throws PCDIException {
        throw new PCDIException("not supported in simulator");
    }

    public void setDataWriteMemoryCommand(BitList tasks, long offset, String address, int wordFormat, int wordSize, String value) throws PCDIException {
        throw new PCDIException("not supported in simulator");
    }

    public void dataEvaluateExpression(BitList tasks, String expression) throws PCDIException {
        throw new PCDIException("dataEvaluateExpression - not supported in simulator yet");
    }

    public void getPartialAIF(BitList tasks, String expr, String key, boolean listChildren, boolean express) throws PCDIException {
        throw new PCDIException("getPartialAIF - not supported in simulator yet");
    }

    public void variableDelete(BitList tasks, String varname) throws PCDIException {
        throw new PCDIException("variableDelete - not supported in simulator yet");
    }

    public synchronized void update(Observable obs, Object obj) {
        if (obs instanceof SimulateProgram) {
            if (obj != null && obj instanceof String[]) {
                String[] args = (String[])obj;
                int task = DebugSimulation2.convertInt(args[0]);
                String state = args[1];
                String file = args[2];
                int line = DebugSimulation2.convertInt(args[3]);
                this.intQueue.addItem(new QueueItem(this.total_process, state, file, line, task));
            }
        } else if (obs instanceof InternalEventQueue) {
            this.updateEvent((QueueItem)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimulateProgram getSimProg(int id) {
        List list = this.sim_list;
        synchronized (list) {
            return (SimulateProgram)this.sim_list.get(id);
        }
    }

    private synchronized void updateEvent(QueueItem qItem) {
        String state = qItem.getState();
        if (state.equals(EXIT_STATE)) {
            this.handleProcessTerminatedEvent(qItem.getTasks(), 0);
        } else if (state.equals(HIT_BPT_STATE)) {
            this.handleBreakpointHitEvent(qItem.getTasks(), qItem.getLine(), 0, new String[0]);
        } else if (state.equals(STEP_END_STATE)) {
            this.handleEndSteppingEvent(qItem.getTasks(), qItem.getLine(), qItem.getFile(), 0, new String[0]);
        }
    }

    public static int convertInt(String s_id) {
        try {
            return Integer.parseInt(s_id);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int random(int min, int max) {
        Random generator = new Random();
        long range = (long)max - (long)min + 1L;
        long fraction = (long)((double)range * generator.nextDouble());
        return (int)(fraction + (long)min);
    }

    private class SimVariable {
        private String var = "";
        private String type = "";
        private String val = "";

        public SimVariable(String var, String type, String val) {
            this.var = var;
            this.type = type;
            this.val = val;
        }

        public String getVariable() {
            return this.var;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.val;
        }
    }
}

