/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.variable;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.debug.internal.ui.PJobVariableManager;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.internal.ui.actions.AddPExpressionAction;
import org.eclipse.ptp.debug.internal.ui.actions.CompareValueAction;
import org.eclipse.ptp.debug.internal.ui.actions.DeletePExpressionAction;
import org.eclipse.ptp.debug.internal.ui.actions.EditPExpressionAction;
import org.eclipse.ptp.debug.internal.ui.actions.UpdatePExpressionAction;
import org.eclipse.ptp.debug.internal.ui.views.AbstractPDebugEventHandler;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableCheckboxTableViewer;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableContentProvider;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableLabelProvider;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableViewEventHandler;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableViewerSorter;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.ui.listeners.IJobChangedListener;
import org.eclipse.ptp.ui.listeners.ISetListener;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.WorkbenchJob;

public class PVariableView
extends AbstractDebugView
implements IJobChangedListener,
ISetListener,
ICheckStateListener {
    private AbstractPDebugEventHandler fEventHandler;
    private UIDebugManager uiManager = null;
    private PVariableCheckboxTableViewer viewer = null;

    protected Viewer createViewer(Composite parent) {
        this.uiManager = PTPDebugUIPlugin.getUIDebugManager();
        this.viewer = new PVariableCheckboxTableViewer(parent, 770);
        PVariableContentProvider contentProvider = new PVariableContentProvider();
        PVariableLabelProvider labelProvider = new PVariableLabelProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setCheckProvider(labelProvider);
        this.viewer.setSorter(new PVariableViewerSorter());
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput(this.uiManager.getJobVariableManager());
        this.viewer.addCheckStateListener(this);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!PVariableView.this.getSelection().isEmpty()) {
                    PVariableView.this.getAction("Edit").run();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PVariableView.this.updateActionsEnable();
            }
        });
        this.uiManager.addJobChangedListener(this);
        this.uiManager.addSetListener(this);
        this.setEventHandler(new PVariableViewEventHandler(this));
        return this.viewer;
    }

    public UIDebugManager getUIManager() {
        return this.uiManager;
    }

    public void refresh() {
        this.viewer.refresh();
        this.updateActionsEnable();
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    protected void setEventHandler(AbstractPDebugEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected AbstractPDebugEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    protected void createActions() {
        this.setAction("Add", (IAction)new AddPExpressionAction(this));
        this.setAction("Edit", (IAction)new EditPExpressionAction(this));
        this.setAction("Delete", (IAction)new DeletePExpressionAction(this));
        this.setAction("Refresh variables", (IAction)new UpdatePExpressionAction(this));
        this.setAction("Compare value", (IAction)new CompareValueAction(this));
        this.updateActionsEnable();
    }

    protected void configureToolBar(IToolBarManager toolBarMgr) {
        toolBarMgr.add((IContributionItem)new Separator("VarGroup"));
        toolBarMgr.appendToGroup("VarGroup", this.getAction("Add"));
        toolBarMgr.appendToGroup("VarGroup", this.getAction("Edit"));
        toolBarMgr.appendToGroup("VarGroup", this.getAction("Delete"));
        toolBarMgr.appendToGroup("VarGroup", this.getAction("Refresh variables"));
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.appendToGroup("VarGroup", this.getAction("Compare value"));
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        menu.add(this.getAction("Add"));
        menu.add(this.getAction("Edit"));
        menu.add(this.getAction("Delete"));
        menu.add(this.getAction("Refresh variables"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction("Compare value"));
        this.updateObjects();
    }

    public void dispose() {
        this.uiManager.removeSetListener(this);
        this.uiManager.removeJobChangedListener(this);
        this.viewer.removeCheckStateListener(this);
        super.dispose();
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
    }

    public void jobChangedEvent(final int type, final String cur_job_id, final String pre_job_id) {
        WorkbenchJob uiJob = new WorkbenchJob("Updating annotation..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PVariableView.this.doJobChangedEvent(type, cur_job_id, pre_job_id, monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    private void doJobChangedEvent(int type, String cur_job_id, String pre_job_id, IProgressMonitor monitor) {
        switch (type) {
            case 0: {
                this.refresh();
                break;
            }
            case 1: {
                if (pre_job_id == null) break;
                this.uiManager.getJobVariableManager().removeJobVariables(pre_job_id);
                this.refresh();
            }
        }
        this.updateActionsEnable();
    }

    private boolean isEmpty() {
        return this.viewer.getTable().getItemCount() == 0;
    }

    private boolean isCurrentJobAvailable() {
        String cur_jid = this.uiManager.getCurrentJobId();
        return cur_jid != null && cur_jid.length() > 0;
    }

    public void updateActionsEnable() {
        this.getAction("Add").setEnabled(this.isCurrentJobAvailable());
        this.getAction("Edit").setEnabled(!this.getSelection().isEmpty());
        this.getAction("Delete").setEnabled(!this.getSelection().isEmpty());
        this.getAction("Refresh variables").setEnabled(!this.isEmpty());
        this.getAction("Compare value").setEnabled(!this.getSelection().isEmpty());
    }

    public void deleteSetEvent(IElementSet set) {
        this.refresh();
    }

    public void changeSetEvent(IElementSet currentSet, IElementSet preSet) {
    }

    public void createSetEvent(IElementSet set, IElement[] elements) {
    }

    public void addElementsEvent(IElementSet set, IElement[] elements) {
    }

    public void removeElementsEvent(IElementSet set, IElement[] elements) {
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object data = event.getElement();
        if (data instanceof PJobVariableManager.JobVariable) {
            ((PJobVariableManager.JobVariable)data).setEnable(event.getChecked());
        }
    }
}

