/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.DebugJobStorage;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITargetConfiguration;
import org.eclipse.ptp.debug.core.events.PDebugEvent;
import org.eclipse.ptp.debug.core.events.PDebugInfo;
import org.eclipse.ptp.debug.core.events.PDebugRegisterInfo;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.internal.core.breakpoint.PLineBreakpoint;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PSession;

public class PCDIDebugModel {
    private final String VALUE_UNKNOWN = "Unkwnon";
    private final String VALUE_ERROR = "Error in getting value";
    private final String SESSION_KEY = "session_key";
    private DebugJobStorage jobStorage = new DebugJobStorage("Job");
    private DebugJobStorage sessionStorage = new DebugJobStorage("Session");

    public void shutdown() {
        Iterator i = this.sessionStorage.getJobValueIterator();
        while (i.hasNext()) {
            IPJob job;
            IPSession pSession = (IPSession)i.next();
            if (pSession == null || (job = pSession.getJob()).isAllStop()) continue;
            job.removeAllProcesses();
            pSession.getPCDISession().shutdown();
            try {
                PDebugUtils.println("-----PCDIDebugModel - waiting debugger to stop");
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.jobStorage.closeDebugJobStorage();
        this.sessionStorage.closeDebugJobStorage();
    }

    public void shutdownSession(IPJob job) {
        IPSession pSession;
        if (job != null && (pSession = (IPSession)this.sessionStorage.removeValue(job.getIDString(), "session_key")) != null) {
            pSession.getPCDISession().shutdown();
        }
    }

    public IPCDISession getPCDISession(String job_id) {
        IPSession pSession = (IPSession)this.sessionStorage.getValue(job_id, "session_key");
        if (pSession != null) {
            return pSession.getPCDISession();
        }
        return null;
    }

    public IPSession createDebuggerSession(IAbstractDebugger debugger, IPLaunch launch, IBinaryParser.IBinaryObject exe, int timeout, IProgressMonitor monitor) throws CoreException {
        PSession pSession = new PSession(debugger.createDebuggerSession(launch, exe, timeout, monitor));
        if (!monitor.isCanceled()) {
            IPJob job = launch.getPJob();
            this.sessionStorage.addValue(job.getIDString(), "session_key", pSession);
            this.newJob(job, pSession.getPCDISession().createBitList());
            this.fireSessionEvent(job, pSession.getPCDISession());
            pSession.getPCDISession().start(monitor);
        }
        return pSession;
    }

    public static String getPluginIdentifier() {
        return PTPDebugCorePlugin.getUniqueIdentifier();
    }

    public void fireSessionEvent(IPJob job, IPCDISession session) {
        PDebugInfo info = new PDebugInfo(job, null, null, null);
        PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(session, 4, 1024, info));
    }

    public void fireRegisterEvent(IPJob job, BitList tasks, boolean refresh) {
        IPCDISession session;
        if (!tasks.isEmpty() && (session = this.getPCDISession(job.getIDString())) != null) {
            PDebugRegisterInfo info = new PDebugRegisterInfo(job, tasks, tasks, null, refresh);
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(session, 4, 2048, info));
        }
    }

    public void fireUnregisterEvent(IPJob job, BitList tasks, boolean refresh) {
        IPCDISession session;
        if (!tasks.isEmpty() && (session = this.getPCDISession(job.getIDString())) != null) {
            PDebugRegisterInfo info = new PDebugRegisterInfo(job, tasks, null, tasks, refresh);
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(session, 8, 2048, info));
        }
    }

    public void removeDebugTarget(final IPLaunch launch, final BitList tasks, final boolean refresh) {
        Job aJob = new Job("Removing the debug targets..."){

            protected IStatus run(IProgressMonitor monitor) {
                int[] taskArray = tasks.toArray();
                int i = 0;
                while (i < taskArray.length) {
                    IPDebugTarget debugTarget;
                    IPJob pjob = launch.getPJob();
                    IPProcess process = pjob.findProcessByTaskId(taskArray[i]);
                    if (process != null) {
                        process.setAttribute("ATTRIB_ISREGISTERED", (Object)new Boolean(false));
                    }
                    if ((debugTarget = launch.getDebugTarget(taskArray[i])) != null) {
                        launch.removeDebugTarget(debugTarget);
                        debugTarget.terminated();
                    }
                    ++i;
                }
                PCDIDebugModel.this.fireUnregisterEvent(launch.getPJob(), tasks, refresh);
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.setPriority(10);
        aJob.schedule();
    }

    public void addNewDebugTargets(final IPLaunch launch, final BitList tasks, final IPCDITarget[] cdiTargets, final IBinaryParser.IBinaryObject file, final boolean resumeTarget, final boolean refresh) {
        Job aJob = new Job("Creating new debug targets..."){

            protected IStatus run(IProgressMonitor monitor) {
                boolean allowTerminate = true;
                boolean allowDisconnect = false;
                int i = 0;
                while (i < cdiTargets.length) {
                    IPJob pjob;
                    IPProcess process;
                    PDebugTarget target = new PDebugTarget(launch, cdiTargets[i], null, file, allowTerminate, allowDisconnect);
                    IPCDITargetConfiguration config = cdiTargets[i].getConfiguration();
                    if (config.supportsResume() && resumeTarget) {
                        try {
                            target.resume();
                        }
                        catch (DebugException e) {
                            PTPDebugCorePlugin.log(e);
                        }
                    }
                    if ((process = (pjob = launch.getPJob()).findProcessByTaskId(target.getTargetID())) != null) {
                        process.setAttribute("ATTRIB_ISREGISTERED", (Object)new Boolean(true));
                    }
                    launch.addDebugTarget(target);
                    ++i;
                }
                PCDIDebugModel.this.fireRegisterEvent(launch.getPJob(), tasks, refresh);
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.setPriority(10);
        aJob.schedule();
    }

    public IPLineBreakpoint[] lineBreakpointsExists(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        IBreakpoint[] breakpoints = this.getPBreakpoints();
        ArrayList<IPLineBreakpoint> foundBreakpoints = new ArrayList<IPLineBreakpoint>(0);
        int i = 0;
        while (i < breakpoints.length) {
            IPLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof IPLineBreakpoint && this.sameSourceHandle(sourceHandle, (breakpoint = (IPLineBreakpoint)breakpoints[i]).getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getLineNumber() == lineNumber) {
                foundBreakpoints.add(breakpoint);
            }
            ++i;
        }
        return foundBreakpoints.toArray(new IPLineBreakpoint[foundBreakpoints.size()]);
    }

    public IPLineBreakpoint lineBreakpointExists(IPLineBreakpoint[] breakpoints, String job_id) throws CoreException {
        int i = 0;
        while (i < breakpoints.length) {
            String bpt_job_id = breakpoints[i].getJobId();
            if (bpt_job_id.equals("Global") || bpt_job_id.equals(job_id)) {
                return breakpoints[i];
            }
            ++i;
        }
        return null;
    }

    public boolean sameSourceHandle(String handle1, String handle2) {
        if (handle1 == null || handle2 == null) {
            return false;
        }
        Path path1 = new Path(handle1);
        Path path2 = new Path(handle2);
        if (path1.isValidPath(handle1) && path2.isValidPath(handle2)) {
            return path1.equals((Object)path2);
        }
        return handle1.equals(handle2);
    }

    public IBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, String job_id, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PTPDebugCorePlugin.getUniqueIdentifier());
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.setid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.cursetid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.jobid", job_id);
        attributes.put("org.eclipse.ptp.debug.core.jobname", jobName);
        return new PLineBreakpoint(resource, attributes, register);
    }

    public IBreakpoint[] getPBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PCDIDebugModel.getPluginIdentifier());
    }

    public IBreakpoint[] findPBreakpoints(String job_id, String set_id) throws CoreException {
        ArrayList<IPLineBreakpoint> bptList = new ArrayList<IPLineBreakpoint>();
        IBreakpoint[] breakpoints = this.getPBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            IPLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof IPLineBreakpoint && (breakpoint = (IPLineBreakpoint)breakpoints[i]).getJobId().equals(job_id) && breakpoint.getSetId().equals(set_id)) {
                bptList.add(breakpoint);
            }
            ++i;
        }
        return bptList.toArray(new IBreakpoint[bptList.size()]);
    }

    public IPBreakpoint[] findPBreakpoints(String job_id, boolean includeGlobal) throws CoreException {
        ArrayList<IPBreakpoint> bptList = new ArrayList<IPBreakpoint>();
        IBreakpoint[] breakpoints = this.getPBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            IPBreakpoint breakpoint;
            String bp_job_id;
            if (breakpoints[i] instanceof IPBreakpoint && ((bp_job_id = (breakpoint = (IPBreakpoint)breakpoints[i]).getJobId()).equals(job_id) || includeGlobal && bp_job_id.equals("Global"))) {
                bptList.add(breakpoint);
            }
            ++i;
        }
        return bptList.toArray(new IPBreakpoint[bptList.size()]);
    }

    public void deletePBreakpoint(final String job_id, final String set_id) {
        Job aJob = new Job("Deleting parallel breakpoint..."){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    IBreakpoint[] breakpoints = PCDIDebugModel.this.findPBreakpoints(job_id, set_id);
                    if (breakpoints.length > 0) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints, true);
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.setPriority(10);
        aJob.schedule();
    }

    public void deletePBreakpoint(final String job_id) {
        Job aJob = new Job("Deleting parallel breakpoint..."){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    IBreakpoint[] breakpoints = PCDIDebugModel.this.findPBreakpoints(job_id, false);
                    if (breakpoints.length > 0) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints, true);
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.setPriority(10);
        aJob.schedule();
    }

    public void updatePBreakpoints(String set_id, IProgressMonitor monitor) throws CoreException {
        try {
            IBreakpoint[] breakpoints = this.getPBreakpoints();
            monitor.beginTask("Updating parallel breakpoint...", breakpoints.length);
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof IPBreakpoint) {
                    ((IPBreakpoint)breakpoints[i]).setCurSetId(set_id);
                    monitor.worked(1);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void newJob(IPJob job, BitList rootTasks) {
        this.createSet(job.getIDString(), "Root", rootTasks);
    }

    public void createSet(String job_id, String set_id, BitList tasks) {
        this.jobStorage.addValue(job_id, set_id, tasks);
    }

    public void addTasks(String job_id, String set_id, BitList tasks) {
        ((BitList)this.jobStorage.getValue(job_id, set_id)).or(tasks);
    }

    public void removeTasks(String job_id, String set_id, BitList tasks) {
        ((BitList)this.jobStorage.getValue(job_id, set_id)).andNot(tasks);
    }

    public void deleteSet(String job_id, String set_id) {
        this.jobStorage.removeValue(job_id, set_id);
    }

    public BitList getTasks(String job_id, String set_id) {
        BitList tasks = (BitList)this.jobStorage.getValue(job_id, set_id);
        if (tasks != null) {
            return tasks.copy();
        }
        return null;
    }

    public void deleteJob(IPJob job) {
        this.jobStorage.removeJobStorage(job.getIDString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getValue(IPCDISession session, int taskID, String var, IProgressMonitor monitor) {
        try {
            IAIF aif = session.getExpressionValue(taskID, var);
            if (aif == null) {
                return "Unkwnon";
            }
            String string = aif.getValue().getValueString();
            return string;
        }
        catch (PCDIException pCDIException) {
            return "Error in getting value";
        }
        catch (AIFException aIFException) {
            return "Error in getting value";
        }
        finally {
            monitor.worked(1);
        }
    }
}

