/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;

public class SessionManager
implements IDebugEventSetListener {
    public SessionManager() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public Object getAdapter(Class adapter) {
        if (SessionManager.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object element;
            DebugEvent event = events[i];
            if (event.getKind() == 8 && (element = event.getSource()) instanceof IDebugTarget && ((IDebugTarget)element).getAdapter(IPCDITarget.class) != null) {
                this.handleTerminateEvent(((IDebugTarget)element).getLaunch(), ((IPCDITarget)((IDebugTarget)element).getAdapter(IPCDITarget.class)).getSession());
            }
            ++i;
        }
    }

    private void handleTerminateEvent(ILaunch launch, IPCDISession session) {
        IDebugTarget[] targets = launch.getDebugTargets();
        boolean terminate = true;
        int i = 0;
        while (i < targets.length) {
            if (targets[i].getAdapter(IPCDITarget.class) != null && session.equals(((IPCDITarget)targets[i].getAdapter(IPCDITarget.class)).getSession()) && !targets[i].isTerminated() && !targets[i].isDisconnected()) {
                terminate = false;
            }
            ++i;
        }
        if (terminate && session.getJob().isAllStop()) {
            try {
                session.terminate();
            }
            catch (PCDIException e) {
                PTPDebugCorePlugin.log((Throwable)((Object)e));
            }
        }
    }
}

