/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugElementStatus;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;

public abstract class PDebugElement
extends PlatformObject
implements IPDebugElement,
IPDebugElementStatus {
    private PDebugTarget fDebugTarget;
    private int fSeverity = 0;
    private String fMessage = null;
    private PDebugElementState fState = PDebugElementState.UNDEFINED;
    private PDebugElementState fOldState = PDebugElementState.UNDEFINED;
    private Object fCurrentStateInfo = null;

    public PDebugElement(PDebugTarget target) {
        this.setDebugTarget(target);
    }

    public String getModelIdentifier() {
        return PCDIDebugModel.getPluginIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    protected void setDebugTarget(PDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected void logError(Exception e) {
        DebugPlugin.log((Throwable)e);
    }

    protected void logError(String message) {
        DebugPlugin.logMessage((String)message, null);
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    protected void fireEventSet(DebugEvent[] events) {
        DebugPlugin.getDefault().fireDebugEventSet(events);
    }

    public void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    public DebugEvent createCreateEvent() {
        return new DebugEvent((Object)this, 4);
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public DebugEvent createResumeEvent(int detail) {
        return new DebugEvent((Object)this, 1, detail);
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    public DebugEvent createSuspendEvent(int detail) {
        return new DebugEvent((Object)this, 2, detail);
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public DebugEvent createTerminateEvent() {
        return new DebugEvent((Object)this, 8);
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 16, detail));
    }

    public DebugEvent createChangeEvent(int detail) {
        return new DebugEvent((Object)this, 16, detail);
    }

    public IPCDISession getCDISession() {
        return this.getCDITarget().getSession();
    }

    public IPCDITarget getCDITarget() {
        return (IPCDITarget)this.getDebugTarget().getAdapter(IPCDITarget.class);
    }

    public static void requestFailed(String message, Exception e) throws DebugException {
        PDebugElement.requestFailed(message, e, 5012);
    }

    public static void targetRequestFailed(String message, PCDIException e) throws DebugException {
        PDebugElement.requestFailed(MessageFormat.format("Target request failed: {0}.", message), (Throwable)((Object)e), 5010);
    }

    public static void requestFailed(String message, Throwable e, int code) throws DebugException {
        PDebugElement.throwDebugException(message, code, e);
    }

    public static void targetRequestFailed(String message, Throwable e) throws DebugException {
        PDebugElement.throwDebugException(MessageFormat.format("Target request failed: {0}.", message), 5010, e);
    }

    public static void notSupported(String message) throws DebugException {
        PDebugElement.throwDebugException(message, 5011, null);
    }

    protected static void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PCDIDebugModel.getPluginIdentifier(), code, message, exception));
    }

    protected void infoMessage(Throwable e) {
        Status newStatus = new Status(1, PCDIDebugModel.getPluginIdentifier(), 10001, e.getMessage(), null);
        PDebugUtils.info((IStatus)newStatus, this.getDebugTarget());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IDebugElement.class)) {
            return this;
        }
        if (adapter.equals(IPDebugElement.class)) {
            return this;
        }
        if (adapter.equals(PDebugElement.class)) {
            return this;
        }
        if (adapter.equals(IPDebugElementStatus.class)) {
            return this;
        }
        if (adapter.equals(IPCDISession.class)) {
            return this.getCDISession();
        }
        if (adapter.equals(IPDebugTarget.class)) {
            return this.getDebugTarget();
        }
        if (adapter.equals(IDebugTarget.class)) {
            return this.getDebugTarget();
        }
        if (adapter.equals(IMemoryBlockRetrieval.class)) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getDebugTarget().getLaunch();
        }
        return super.getAdapter(adapter);
    }

    protected void setStatus(int severity, String message) {
        this.fSeverity = severity;
        this.fMessage = message;
        if (this.fMessage != null) {
            this.fMessage.trim();
        }
    }

    protected void resetStatus() {
        this.fSeverity = 0;
        this.fMessage = null;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public PDebugElementState getState() {
        return this.fState;
    }

    protected synchronized void setState(PDebugElementState state) throws IllegalArgumentException {
        this.fOldState = this.fState;
        this.fState = state;
    }

    protected synchronized void restoreState() {
        this.fState = this.fOldState;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    protected void setCurrentStateInfo(Object currentStateInfo) {
        this.fCurrentStateInfo = currentStateInfo;
    }
}

