/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.aif.IAIFTypeString;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueChar;
import org.eclipse.ptp.debug.core.aif.IAIFValueFloat;
import org.eclipse.ptp.debug.core.aif.IAIFValueInt;
import org.eclipse.ptp.debug.core.aif.IAIFValuePointer;
import org.eclipse.ptp.debug.core.aif.IAIFValueReference;
import org.eclipse.ptp.debug.core.aif.IAIFValueString;
import org.eclipse.ptp.debug.core.aif.ITypeAggregate;
import org.eclipse.ptp.debug.core.aif.ITypeDerived;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPType;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.AbstractPVariable;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PType;
import org.eclipse.ptp.debug.internal.core.model.PVariable;
import org.eclipse.ptp.debug.internal.core.model.PVariableFactory;

public class PValue
extends AbstractPValue {
    private String fValueString = null;
    private List fVariables = Collections.EMPTY_LIST;
    private PType fType;
    private IPCDIVariable fVariable;

    protected PValue(PVariable parent, IPCDIVariable variable) {
        super(parent);
        this.fVariable = variable;
    }

    protected PValue(PVariable parent, String message) {
        super(parent);
        this.setStatus(2, message);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getUnderlyingValue() != null) {
            boolean isSuspended;
            this.resetStatus();
            IPStackFrame pframe = this.getParentVariable().getStackFrame();
            boolean bl = isSuspended = pframe == null ? this.getCDITarget().isSuspended() : pframe.isSuspended();
            if (isSuspended) {
                try {
                    if (this.fVariable == null) {
                        PValue.targetRequestFailed("No variable found", null);
                    }
                    this.fValueString = this.processUnderlyingValue(this.fVariable.getType(), this.fVariable.getValue());
                }
                catch (PCDIException pe) {
                    this.setStatus(2, pe.getMessage());
                }
                catch (AIFException e) {
                    this.setStatus(2, e.getMessage());
                }
            }
        }
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            try {
                List vars = this.getCDIVariables();
                this.fVariables = new ArrayList(vars.size());
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(PVariableFactory.createLocalVariable(this, (IPCDIVariable)it.next()));
                }
                this.resetStatus();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        block5: {
            IAIFType type;
            block6: {
                IPCDIVariable var = this.getCurrentVariable();
                if (var == null) break block5;
                type = var.getType();
                if (!(type instanceof ITypeAggregate)) break block6;
                return true;
            }
            try {
                if (type instanceof ITypeDerived) {
                    return true;
                }
            }
            catch (PCDIException e) {
                PValue.targetRequestFailed(e.getMessage(), null);
            }
        }
        return false;
    }

    public IPCDIVariable getCurrentVariable() {
        return this.fVariable;
    }

    public IAIFValue getUnderlyingValue() {
        try {
            return this.getCurrentVariable().getValue();
        }
        catch (PCDIException pCDIException) {
            return null;
        }
    }

    protected List getCDIVariables() throws DebugException {
        IPCDIVariable[] vars = null;
        try {
            IPCDIVariable var = this.getCurrentVariable();
            vars = var.getChildren();
            if (vars == null) {
                vars = new IPCDIVariable[]{};
            }
        }
        catch (PCDIException e) {
            PValue.requestFailed(e.getMessage(), (Exception)((Object)e));
        }
        return Arrays.asList(vars);
    }

    protected synchronized void setChanged(boolean changed) {
        if (changed) {
            this.fValueString = null;
            this.resetStatus();
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).setChanged(changed);
        }
    }

    public void dispose() {
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).dispose();
        }
    }

    protected String processUnderlyingValue(IAIFType aifType, IAIFValue aifValue) throws AIFException {
        if (aifValue != null) {
            if (aifType instanceof IAIFTypeChar) {
                return this.getCharValueString((IAIFValueChar)aifValue);
            }
            if (aifType instanceof IAIFTypeInt) {
                return this.getIntValueString((IAIFValueInt)aifValue);
            }
            if (aifType instanceof IAIFTypeFloat) {
                return this.getFloatingPointValueString((IAIFValueFloat)aifValue);
            }
            if (aifType instanceof IAIFTypePointer) {
                return this.getPointerValueString((IAIFValuePointer)aifValue);
            }
            if (aifType instanceof IAIFTypeReference) {
                return this.processUnderlyingValue(aifType, ((IAIFValueReference)aifValue).getParent());
            }
            if (aifType instanceof IAIFTypeString) {
                return this.getWCharValueString((IAIFValueString)aifValue);
            }
            if (aifType instanceof ITypeAggregate) {
                return "{...}";
            }
            return aifValue.getValueString();
        }
        return null;
    }

    private String getCharValueString(IAIFValueChar value) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        char charValue = value.charValue();
        if (PVariableFormat.NATURAL.equals(format)) {
            return Character.isISOControl(charValue) && charValue != '\b' && charValue != '\t' && charValue != '\n' && charValue != '\f' && charValue != '\r' || charValue < '\u0000' ? "" : "'" + value.getValueString() + "'";
        }
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Integer.toString((byte)charValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Integer.toString((byte)charValue);
            sb.append(stringValue.length() > 2 ? stringValue.substring(stringValue.length() - 2) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getIntValueString(IAIFValueInt value) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        String stringValue = value.getValueString();
        if (PVariableFormat.NATURAL.equals(format) || PVariableFormat.DECIMAL.equals(format)) {
            return stringValue;
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            if (value.isShort()) {
                stringValue = Integer.toHexString(value.shortValue());
            } else if (value.isInt()) {
                stringValue = Integer.toHexString(value.intValue());
            } else if (value.isLong()) {
                stringValue = Long.toHexString(value.longValue());
            }
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getFloatingPointValueString(IAIFValueFloat value) throws AIFException {
        if (value.isDouble()) {
            return this.getDoubleValueString(value.getValueString());
        }
        if (value.isFloat()) {
            return this.getFloatValueString(value.getValueString());
        }
        return value.getValueString();
    }

    private String getFloatValueString(String floatValue) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format)) {
            return floatValue;
        }
        Float flt = new Float(floatValue);
        if (flt.isNaN() || flt.isInfinite()) {
            return "";
        }
        long longValue = flt.longValue();
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return floatValue;
    }

    private String getDoubleValueString(String doubleValue) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format)) {
            return doubleValue;
        }
        Double dbl = new Double(doubleValue);
        if (dbl.isNaN() || dbl.isInfinite()) {
            return "";
        }
        long longValue = dbl.longValue();
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
            return sb.toString();
        }
        return doubleValue;
    }

    private String getPointerValueString(IAIFValuePointer value) throws AIFException {
        IAddressFactory factory = ((PDebugTarget)this.getDebugTarget()).getAddressFactory();
        BigInteger pv = value.pointerValue();
        if (pv == null) {
            return "";
        }
        IAddress address = factory.createAddress(pv);
        if (address == null) {
            return "";
        }
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format) || PVariableFormat.HEXADECIMAL.equals(format)) {
            return address.toHexAddressString();
        }
        if (PVariableFormat.DECIMAL.equals(format)) {
            return address.toString();
        }
        return null;
    }

    private String getWCharValueString(IAIFValueString value) throws AIFException {
        return value.getValueString();
    }

    protected void reset() {
        this.resetStatus();
        this.fValueString = null;
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).resetValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPType getType() throws DebugException {
        IAIFValue aifValue = this.getUnderlyingValue();
        if (this.fType == null && aifValue != null) {
            PValue pValue = this;
            synchronized (pValue) {
                if (this.fType == null) {
                    this.fType = new PType(aifValue.getType());
                }
            }
        }
        return this.fType;
    }

    protected void preserve() {
        this.setChanged(false);
        this.resetStatus();
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).preserve();
        }
    }
}

