/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.orte.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.PreferenceConstants;
import org.eclipse.ptp.internal.core.CoreMessages;
import org.eclipse.ptp.ui.utils.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class OMPIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
PreferenceConstants {
    public static final String EMPTY_STRING = "";
    protected Text orteServerText = null;
    protected Button browseButton = null;
    protected Button fManualButton = null;
    private String orteServerFile = "";
    private boolean loading = true;
    protected WidgetListener listener = new WidgetListener();

    public OMPIPreferencePage() {
        this.setPreferenceStore(PTPCorePlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.createORTEContents(composite);
        this.loading = true;
        this.loadSaved();
        this.loading = false;
        this.defaultSetting();
        return composite;
    }

    private void createORTEContents(Composite parent) {
        Group bGroup = new Group(parent, 16);
        bGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        bGroup.setLayoutData((Object)this.spanGridData(768, 2));
        bGroup.setText(CoreMessages.getResourceString((String)"OMPIPreferencesPage.group_proxy"));
        new Label((Composite)bGroup, 64).setText("Enter the path to the PTP ORTE proxy server.");
        Composite orteserver = new Composite((Composite)bGroup, 0);
        orteserver.setLayout((Layout)this.createGridLayout(3, false, 0, 0));
        orteserver.setLayoutData((Object)this.spanGridData(768, 5));
        new Label(orteserver, 0).setText(CoreMessages.getResourceString((String)"OMPIPreferencesPage.orteServer_text"));
        this.orteServerText = new Text(orteserver, 2052);
        this.orteServerText.setLayoutData((Object)new GridData(768));
        this.orteServerText.addModifyListener((ModifyListener)this.listener);
        this.browseButton = SWTUtil.createPushButton((Composite)orteserver, (String)CoreMessages.getResourceString((String)"PTPPreferencesPage.browseButton"), null);
        this.browseButton.addSelectionListener((SelectionListener)this.listener);
        this.fManualButton = this.createCheckButton(parent, CoreMessages.getResourceString((String)"OMPIPreferencesPage.manual"));
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected void defaultSetting() {
        this.orteServerText.setText(this.orteServerFile);
    }

    private void loadSaved() {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        this.orteServerFile = preferences.getString("ORTE_PROXY_PATH");
        if (this.orteServerFile.equals(EMPTY_STRING)) {
            this.orteServerFile = PTPCorePlugin.getDefault().locateFragmentFile("org.eclipse.ptp", "ptp_orte_proxy");
        }
        this.orteServerText.setText(this.orteServerFile);
        this.fManualButton.setSelection(preferences.getBoolean("ORTE_LAUNCH_MANUALLY"));
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    private void store() {
        this.orteServerFile = this.orteServerText.getText();
    }

    public boolean performOk() {
        this.store();
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        preferences.setValue("ORTE_PROXY_PATH", this.orteServerFile);
        preferences.setValue("ORTE_LAUNCH_MANUALLY", this.fManualButton.getSelection());
        PTPCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void handlePathBrowseButtonSelected() {
        String selectedPath;
        File path;
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(CoreMessages.getResourceString((String)"OMPIPreferencesPage.Select_ORTE_PROXY_FILE"));
        String correctPath = this.getFieldContent(this.orteServerText.getText());
        if (correctPath != null && (path = new File(correctPath)).exists()) {
            dialog.setFilterPath(path.isFile() ? correctPath : path.getParent());
        }
        if ((selectedPath = dialog.open()) != null) {
            this.orteServerText.setText(selectedPath);
        }
    }

    protected boolean isValidORTEdSetting() {
        String name = this.getFieldContent(this.orteServerText.getText());
        if (name == null) {
            this.setErrorMessage(CoreMessages.getResourceString((String)"OMPIPreferencesPage.Incorrect_server_file"));
        } else {
            File path = new File(name);
            if (!path.exists() || !path.isFile()) {
                this.setErrorMessage(CoreMessages.getResourceString((String)"OMPIPreferencesPage.Incorrect_server_file"));
            }
        }
        return true;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidORTEdSetting()) {
            return;
        }
        this.performOk();
        this.setValid(true);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == OMPIPreferencePage.this.browseButton) {
                OMPIPreferencePage.this.handlePathBrowseButtonSelected();
            } else {
                OMPIPreferencePage.this.updatePreferencePage();
            }
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (!OMPIPreferencePage.this.loading && source == OMPIPreferencePage.this.orteServerText) {
                OMPIPreferencePage.this.updatePreferencePage();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                OMPIPreferencePage.this.updatePreferencePage();
            }
        }
    }
}

