/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.internal.core.Parent;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPUniverseControl;

public class PJob
extends Parent
implements IPJobControl {
    protected String NAME_TAG = "root ";
    protected boolean isDebugJob = false;
    private ArrayList taskIdMap = new ArrayList();
    public static final int BASE_OFFSET = 10000;
    public static final int STATE_NEW = 5000;

    public PJob(IPUniverseControl uni, String name, String key, int jobNumber) {
        super(uni, name, key, 13);
        this.setAttribute("ATTRIB_JOBID", new Integer(jobNumber));
    }

    public boolean isDebug() {
        return this.isDebugJob;
    }

    public void setDebug() {
        this.isDebugJob = true;
    }

    public IPMachine[] getMachines() {
        IPNode[] nodes = this.getNodes();
        ArrayList<IPMachine> array = new ArrayList<IPMachine>(0);
        int i = 0;
        while (i < nodes.length) {
            IPMachine machine = nodes[i].getMachine();
            if (machine != null && !array.contains(machine)) {
                array.add(machine);
            }
            ++i;
        }
        return array.toArray(new IPMachine[array.size()]);
    }

    public String getJobNumber() {
        return "" + (Integer)this.getAttribute("ATTRIB_JOBID");
    }

    public int getJobNumberInt() {
        return (Integer)this.getAttribute("ATTRIB_JOBID");
    }

    public synchronized IPNode[] getSortedNodes() {
        IPElementControl[] nodes = (IPNodeControl[])this.getNodes();
        this.sort(nodes);
        return nodes;
    }

    public synchronized IPNode[] getNodes() {
        IPProcess[] processes = this.getProcesses();
        ArrayList<IPNode> array = new ArrayList<IPNode>(0);
        int i = 0;
        while (i < processes.length) {
            IPNode node = processes[i].getNode();
            if (node != null && !array.contains(node)) {
                array.add(node);
            }
            ++i;
        }
        return array.toArray(new IPNodeControl[array.size()]);
    }

    public synchronized IPProcess[] getProcesses() {
        return this.getCollection().toArray(new IPProcessControl[this.size()]);
    }

    public synchronized IPProcess[] getSortedProcesses() {
        IPElementControl[] processes = (IPProcessControl[])this.getProcesses();
        this.sort(processes);
        return processes;
    }

    public synchronized IPProcess findProcess(String processNumber) {
        IPElementControl element = this.findChild(processNumber);
        if (element != null) {
            return (IPProcessControl)element;
        }
        return null;
    }

    public synchronized IPProcess findProcessByName(String pname) {
        Collection col = this.getCollection();
        for (Object ob : col) {
            IPProcessControl proc;
            if (!(ob instanceof IPProcessControl) || !(proc = (IPProcessControl)ob).getElementName().equals(pname)) continue;
            return proc;
        }
        return null;
    }

    public int totalNodes() {
        return this.getNodes().length;
    }

    public int totalProcesses() {
        return this.size();
    }

    public void removeAllProcesses() {
        IPProcess[] processes = this.getProcesses();
        int i = 0;
        while (i < processes.length) {
            processes[i].clearOutput();
            ++i;
        }
        this.removeChildren();
    }

    public IPUniverse getUniverse() {
        IPElementControl current = this;
        do {
            if (!(current instanceof IPUniverse)) continue;
            return (IPUniverse)((Object)current);
        } while ((current = current.getParent()) != null);
        return null;
    }

    public void addChild(IPElementControl member) {
        super.addChild(member);
        if (member instanceof IPProcessControl) {
            IPProcessControl p = (IPProcessControl)member;
            this.taskIdMap.add(p.getTaskId(), "" + p.getID());
        }
    }

    public synchronized IPProcess findProcessByTaskId(int taskId) {
        String procNumber = (String)this.taskIdMap.get(taskId);
        if (procNumber == null) {
            return null;
        }
        return this.findProcess(procNumber);
    }

    public Object getAttribute(String key) {
        return this.getAttribute(4, key);
    }

    public void setAttribute(String key, Object o) {
        this.setAttribute(4, key, o);
    }

    public String[] getAttributeKeys() {
        return this.getAttributeKeys(4);
    }

    public String getName() {
        return this.getElementName();
    }
}

