/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.core.OutputTextFile;
import org.eclipse.ptp.internal.core.Parent;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPProcessControl;

public class PProcess
extends Parent
implements IPProcessControl {
    protected String NAME_TAG = "process ";
    private String pid = null;
    private String status = null;
    private String exitCode = null;
    private String signalName = null;
    private boolean isTerminated = false;
    private OutputTextFile outputFile = null;
    protected int storeLine = 0;
    protected IPNodeControl node;

    public static void deleteOutputFiles(String jobName, String owner) {
        String path = PProcess.outputDirPath(jobName, owner);
        File outputDirectory = new File(path);
        if (outputDirectory.exists()) {
            File[] files = outputDirectory.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
    }

    private static String outputDirPath(String jobName, String owner) {
        Preferences preferences;
        String path;
        String ownerDir = "";
        if (owner.length() > 0) {
            ownerDir = "/ptp_" + owner;
        }
        if ((path = (preferences = PTPCorePlugin.getDefault().getPluginPreferences()).getString("OUTPUT_DIR")) == null || path.length() == 0) {
            path = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("output").toOSString();
        }
        return path.concat(String.valueOf(ownerDir) + "/" + jobName);
    }

    public PProcess(IPElementControl element, String owner, String name, String key, String pid, int taskId, String status, String exitCode, String signalName) {
        super(element, name, key, 14);
        if (element == null) {
            throw new IllegalArgumentException("Process, " + name + ", was created with a null parent.");
        }
        this.pid = pid;
        this.setAttribute("ATTRIB_TASKID", new Integer(taskId));
        this.setAttribute("ATTRIB_ISREGISTERED", new Boolean(false));
        this.exitCode = exitCode;
        this.status = status;
        String jobName = name.substring(0, name.indexOf(95));
        String outputDirectoryPath = PProcess.outputDirPath(jobName, owner);
        this.setOutputStore(outputDirectoryPath);
        this.outputFile = new OutputTextFile(Integer.toString(taskId), outputDirectoryPath, this.storeLine);
    }

    private void setOutputStore(String outputDirectoryPath) {
        File outputDirectory;
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        this.storeLine = preferences.getInt("STORE_LINE");
        if (this.storeLine == 0) {
            this.storeLine = 100;
        }
        if (!(outputDirectory = new File(outputDirectoryPath)).exists()) {
            outputDirectory.mkdirs();
        }
    }

    public IPJob getJob() {
        IPElementControl current = this;
        do {
            if (!(current instanceof IPJobControl)) continue;
            return (IPJobControl)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public String getProcessNumber() {
        return "" + this.getTaskId();
    }

    public void setStatus(String status) {
        this.status = status == null ? "unknown" : status;
    }

    public void setExitCode(String exitCode) {
        this.exitCode = exitCode;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getPid() {
        return this.pid;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getSignalName() {
        return this.signalName;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void removeProcess() {
        IPNodeControl parent = (IPNodeControl)this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    public void setTerminated(boolean isTerminated) {
        this.isTerminated = isTerminated;
    }

    public void addOutput(String output) {
        this.outputFile.write(String.valueOf(output) + "\n");
    }

    public String getContents() {
        return this.outputFile.getContents();
    }

    public String[] getOutputs() {
        return null;
    }

    public void clearOutput() {
        this.outputFile.delete();
    }

    public boolean isAllStop() {
        return this.getStatus().startsWith("exited") || this.getStatus().startsWith("error");
    }

    public void setNode(IPNode node) {
        this.node = (IPNodeControl)node;
        if (node != null) {
            this.node.addChild(this);
        }
    }

    public IPNode getNode() {
        return this.node;
    }

    public int getTaskId() {
        return (Integer)this.getAttribute("ATTRIB_TASKID");
    }

    public Object getAttribute(String key) {
        return this.getAttribute(5, key);
    }

    public void setAttribute(String key, Object o) {
        this.setAttribute(5, key, o);
    }

    public String[] getAttributeKeys() {
        return this.getAttributeKeys(5);
    }

    public String getName() {
        return this.getElementName();
    }

    public IPProcess getParentProcess() {
        return (IPProcess)((Object)this.getParent());
    }

    public void setParent(IPElementControl parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Process, " + this.getName() + ", set to null parent");
        }
        super.setParent(parent);
    }

    public int getNumChildProcesses() {
        return this.size();
    }
}

