/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.analysis.PldtAstVisitor;

public class MpiCASTVisitor
extends PldtAstVisitor {
    private static final String PREFIX = "MPI_";
    private static final boolean traceOn = false;

    public MpiCASTVisitor(List mpiIncludes, String fileName, ScanReturn msr) {
        super(mpiIncludes, fileName, msr);
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        ARTIFACT_CALL = "MPI Call";
        ARTIFACT_CONSTANT = "MPI Constant";
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            if (astExpr instanceof IASTIdExpression) {
                boolean preProcUsed;
                IASTName tempFN = ((IASTIdExpression)astExpr).getName();
                IBinding tempBIND = tempFN.resolveBinding();
                String tempNAME = tempBIND.getName();
                boolean bl = preProcUsed = !signature.equals(tempNAME);
                if (preProcUsed) {
                    signature = tempNAME;
                }
            }
            if (signature.startsWith(PREFIX) && astExpr instanceof IASTIdExpression) {
                IASTName funcName = ((IASTIdExpression)astExpr).getName();
                this.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof IASTLiteralExpression) {
            this.processMacroLiteral((IASTLiteralExpression)expression);
        }
        return 3;
    }
}

