/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.AnalysisUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class RunAnalyseBase
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final boolean traceOn = false;
    private static final int INDENT_INCR = 2;
    protected boolean forceEcho = false;
    protected IWorkbenchWindow window;
    protected boolean cancelledByUser = false;
    protected int cumulativeArtifacts = 0;
    protected String name;
    protected ArtifactMarkingVisitor visitor;
    protected String markerID;
    private boolean err = false;
    protected Shell shell;
    private IStructuredSelection selection;
    private static final String SPACES = "                                                                                            ";

    public RunAnalyseBase(String name, ArtifactMarkingVisitor visitor, String markerID) {
        this.name = name;
        this.visitor = visitor;
        this.markerID = markerID;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        this.cancelledByUser = false;
        this.err = false;
        this.cumulativeArtifacts = 0;
        this.readPreferences();
        if (this.selection == null || this.selection.isEmpty()) {
            MessageDialog.openWarning(null, (String)"No files selected for analysis.", (String)"Please select a source file or container (folder or project) to analyze.");
            return;
        }
        final List includes = this.getIncludePath();
        if (this.areIncludePathsNeeded() && includes.isEmpty()) {
            System.out.println("RunAnalyseBase.run(), no include paths found.");
            MessageDialog.openWarning((Shell)this.shell, (String)(String.valueOf(this.name) + " Include Paths Not Found"), (String)("Please first specify the " + this.name + " include paths in the Preferences page."));
        } else {
            WorkspaceModifyOperation wmo = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    RunAnalyseBase.this.err = RunAnalyseBase.this.runResources(monitor, 0, includes);
                }
            };
            ProgressMonitorDialog pmdialog = new ProgressMonitorDialog(this.shell);
            try {
                pmdialog.run(true, true, (IRunnableWithProgress)wmo);
            }
            catch (InvocationTargetException e) {
                this.err = true;
                System.out.println("Error running analysis: ITE " + e.getMessage());
                System.out.println("  cause: " + e.getCause() + " - " + e.getCause().getMessage());
                Throwable th = e.getCause();
                th.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                this.cancelledByUser = true;
            }
        }
        String artsFound = "\nNumber of " + this.name + " Artifacts found: " + this.cumulativeArtifacts;
        if (this.cancelledByUser) {
            MessageDialog.openInformation(null, (String)"Partial Analysis Complete.", (String)("Partial Analysis complete.  Cancelled by User." + artsFound));
        } else {
            String msg = "***Analysis is complete.";
            if (!this.err) {
                String key = "showAnalysisConfirmation";
                IPreferenceStore pf = CommonPlugin.getDefault().getPreferenceStore();
                boolean showDialog = pf.getBoolean("showAnalysisConfirmation");
                if (showDialog) {
                    String title = "Analysis complete.";
                    String sMsg = String.valueOf(this.cumulativeArtifacts) + " " + this.name + " Artifacts found";
                    String togMsg = "Don't show me this again";
                    MessageDialogWithToggle.openInformation((Shell)this.shell, (String)title, (String)sMsg, (String)togMsg, (boolean)false, (IPreferenceStore)pf, (String)key);
                    this.showStatusMessage(sMsg, "RunAnalyseBase.run()");
                }
                this.activateProblemsView();
                this.activateArtifactView();
            } else {
                this.showStatusMessage(msg, "RunAnalyseBase.run() error");
                msg = "Analysis completed with errors";
                MessageDialog.openError(null, (String)"Analysis completed with errors", (String)(String.valueOf(msg) + artsFound));
            }
        }
    }

    protected boolean runResources(IProgressMonitor monitor, int indent, List includes) throws InterruptedException {
        boolean foundError = false;
        int count = this.countFilesSelected();
        monitor.beginTask("Analysis", count);
        Iterator iter = this.selection.iterator();
        while (iter.hasNext()) {
            IResource res;
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            Object obj = iter.next();
            if (!(obj instanceof IAdaptable) || (res = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) == null) continue;
            boolean err = this.runResource(monitor, res, indent, includes);
            foundError |= err;
        }
        monitor.done();
        return foundError;
    }

    protected int countFilesSelected() {
        int count = 0;
        for (Object obj : this.selection) {
            if (!(obj instanceof IAdaptable)) continue;
            IResource res = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
            count += this.countFiles(res);
        }
        return count;
    }

    protected int countFiles(IResource res) {
        if (res instanceof IFile) {
            return 1;
        }
        if (res instanceof IContainer) {
            int count = 0;
            try {
                IResource[] kids = ((IContainer)res).members();
                int i = 0;
                while (i < kids.length) {
                    IResource child = kids[i];
                    count += this.countFiles(child);
                    ++i;
                }
                return count;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    protected abstract void activateArtifactView();

    protected abstract void activateProblemsView();

    protected abstract List getIncludePath();

    private void showStatusMessage(String message, String debugMessage) {
        IWorkbenchWindow ww = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = ww.getActivePage();
        IViewReference[] viewRefs = page.getViewReferences();
        int j = 0;
        while (j < viewRefs.length) {
            IViewReference reference = viewRefs[j];
            IViewPart vp = reference.getView(false);
            if (vp != null) {
                vp.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
            }
            ++j;
        }
    }

    protected void readPreferences() {
        Preferences pref = CommonPlugin.getDefault().getPluginPreferences();
        this.forceEcho = pref.getBoolean("forceEcho");
    }

    protected boolean runResource(IProgressMonitor monitor, IResource resource, int indent, List includes) throws InterruptedException {
        indent += 2;
        boolean foundError = false;
        if (!monitor.isCanceled()) {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String filename = file.getName();
                if (AnalysisUtil.validForAnalysis(filename)) {
                    ScanReturn results = this.analyse(monitor, file, includes);
                    boolean bl = foundError = foundError || results == null || results.wasError();
                    if (foundError) {
                        int stopHere = 0;
                        System.out.println("found error on " + file.getName() + " " + stopHere);
                    }
                    if (results != null) {
                        this.processResults(results, resource);
                    }
                }
                return foundError;
            }
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] mems = container.members();
                    int i = 0;
                    while (i < mems.length) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        boolean err = this.runResource(monitor, mems[i], indent, includes);
                        foundError = foundError || err;
                        ++i;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else {
            String name = "";
            if (resource instanceof IResource) {
                IResource res = resource;
                IPath path = res.getProjectRelativePath();
                name = path.toString();
            }
            System.out.println("Cancelled by User, aborting analysis on subsequent files... " + name);
            throw new InterruptedException();
        }
        return foundError;
    }

    protected void processResults(ScanReturn results, IResource resource) {
        List artifacts = results.getArtifactList();
        this.visitor.visitFile(resource, artifacts);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public ScanReturn analyse(IProgressMonitor monitor, IFile file, List includes) {
        boolean wasError;
        String errMsg = null;
        monitor.subTask("Starting Analysis...");
        String rawPath = file.getRawLocation().toString();
        monitor.subTask(" on " + rawPath);
        ScanReturn scanReturn = this.doArtifactAnalysis(file, includes);
        monitor.worked(1);
        int numArtifacts = scanReturn.getArtifactList().size();
        this.cumulativeArtifacts += numArtifacts;
        if (scanReturn == null) {
            System.out.println("ScanReturn result is NULL.  No results for " + file.getProjectRelativePath());
            errMsg = "Error: No results were returned from analysis of " + file.getProjectRelativePath();
            MessageDialog.openError((Shell)this.shell, (String)"Error in Analysis", (String)errMsg);
        }
        if (scanReturn != null && (wasError = scanReturn.wasError())) {
            System.out.println("RunAnalyseBase.analyse...Error...");
        }
        return scanReturn;
    }

    private String getSpaces(int indent) {
        String indentSpace = "";
        try {
            indentSpace = SPACES.substring(0, indent);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.println("RunAnalyseBase: Nesting level " + indent + " exceeds print indent; INCR at each level is " + 2);
        }
        return indentSpace;
    }

    void println(String str) {
        System.out.println(str);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public String getPrefacedName(Object obj) {
        String preface = "";
        if (obj instanceof IFolder) {
            preface = "Contents of Folder: ";
        } else if (obj instanceof IProject) {
            preface = "Contents of Project: ";
        } else if (obj instanceof IFile) {
            preface = "Source file: ";
        }
        String res = String.valueOf(preface) + ((IResource)obj).getName();
        return res;
    }

    public abstract ScanReturn doArtifactAnalysis(IFile var1, List var2);

    public boolean areIncludePathsNeeded() {
        return true;
    }
}

