/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.PAST;

import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public abstract class PASTNode
implements IASTNode {
    protected ASTNode astNode_ = null;
    protected boolean compiled_ = false;
    protected int startingLine_ = -1;
    protected int startLocation_ = -1;
    protected int endLocation_ = -1;
    protected String filename_ = "";

    public PASTNode(ASTNode astNode) {
        this.astNode_ = astNode;
        this.getLocationInfo();
    }

    public PASTNode(PASTNode n) {
        this.astNode_ = n.astNode_;
        this.compiled_ = n.compiled_;
        this.startingLine_ = n.startingLine_;
        this.startLocation_ = n.startLocation_;
        this.filename_ = n.filename_;
    }

    protected void getLocationInfo() {
        IASTNodeLocation[] locations = this.astNode_.getNodeLocations();
        this.filename_ = this.astNode_.getContainingFilename();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
                this.startingLine_ = astFileLocation.getStartingLineNumber();
                this.startLocation_ = astFileLocation.getNodeOffset();
                this.endLocation_ = astFileLocation.getNodeOffset() + astFileLocation.getNodeLength();
            }
        }
    }

    public String getFilename() {
        return this.filename_;
    }

    public int getStartingLine() {
        return this.startingLine_;
    }

    public int getStartLocation() {
        return this.startLocation_;
    }

    public int getEndLocation() {
        return this.endLocation_;
    }

    public abstract String getType();

    public void setCompiled(boolean compiled) {
        this.compiled_ = compiled;
    }

    public boolean isCompiled() {
        return this.compiled_;
    }

    public boolean accept(ASTVisitor visitor) {
        return this.astNode_.accept(visitor);
    }

    public String getContainingFilename() {
        return this.astNode_.getContainingFilename();
    }

    public IASTFileLocation getFileLocation() {
        return this.astNode_.getFileLocation();
    }

    public IASTNodeLocation[] getNodeLocations() {
        return this.astNode_.getNodeLocations();
    }

    public IASTNode getParent() {
        return this.astNode_.getParent();
    }

    public ASTNodeProperty getPropertyInParent() {
        return this.astNode_.getPropertyInParent();
    }

    public String getRawSignature() {
        return this.astNode_.getRawSignature();
    }

    public IASTTranslationUnit getTranslationUnit() {
        return this.astNode_.getTranslationUnit();
    }

    public void setParent(IASTNode node) {
        this.astNode_.setParent(node);
    }

    public void setPropertyInParent(ASTNodeProperty property) {
        this.astNode_.setPropertyInParent(property);
    }
}

