/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class Utility {
    public static final String ConcurrencyType = "org.eclipse.ptp.pldt.openmp.analysis.concurrency";
    public static final String NonConcurrencyType = "org.eclipse.ptp.pldt.openmp.analysis.nonconcurrency";

    public static Location getLocation(IASTNode node) {
        ASTNode astnode;
        ASTNode aSTNode = astnode = node instanceof ASTNode ? (ASTNode)node : null;
        if (astnode == null) {
            return null;
        }
        IASTFileLocation ifl = node.getFileLocation();
        int offset = 0;
        int length = 0;
        if (ifl != null) {
            offset = ifl.getNodeOffset();
            length = ifl.getNodeLength();
        } else {
            IASTNodeLocation[] locs = node.getNodeLocations();
            if (locs == null || locs.length == 0) {
                return null;
            }
            offset = locs[0].getNodeOffset();
            length = astnode.getLength();
        }
        return new Location(node, offset, offset + length - 1);
    }

    public static void removeConcurrencyMarkers(IAnnotationModel am) {
        LinkedList ais = new LinkedList();
        Iterator ai = am.getAnnotationIterator();
        while (ai.hasNext()) {
            ais.add(ai.next());
        }
        for (Annotation a : ais) {
            if (!a.getType().equals(ConcurrencyType) && !a.getType().equals(NonConcurrencyType)) continue;
            am.removeAnnotation(a);
        }
    }

    public static IDocument getDocument(String fullPathName) {
        IFile f;
        IResource r = ParserUtil.getResourceForFilename((String)fullPathName);
        IFile iFile = f = r instanceof IFile ? (IFile)r : null;
        if (f == null) {
            return null;
        }
        return Utility.getDocument(f);
    }

    public static IDocument getDocument(IFile file) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
        IDocument document = null;
        if (textFileBuffer != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    public static class Location {
        public IASTNode node_ = null;
        public int low_ = 0;
        public int high_ = 0;

        public Location(IASTNode node, int low, int high) {
            this.node_ = node;
            this.low_ = low;
            this.high_ = high;
        }

        public int getLow() {
            return this.low_;
        }

        public int getHigh() {
            return this.high_;
        }
    }
}

