/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.editorHelp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionPrototypeSummaryImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionSummaryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MPIDocXMLParser {
    public static void main(String[] args) {
        File file = new File(args[0]);
        try {
            List functions = MPIDocXMLParser.parseDOM(new FileInputStream(file));
            System.out.println("num of functions gathered: " + functions.size());
            System.out.println("first function summary:");
            System.out.println((FunctionSummaryImpl)functions.iterator().next());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static List parseDOM(InputStream xmlIn) {
        ArrayList<FunctionSummaryImpl> mpiFuncList = new ArrayList<FunctionSummaryImpl>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (xmlIn != null) {
                document = builder.parse(xmlIn);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (document != null) {
            NodeList functionList = document.getElementsByTagName("function");
            int i = 0;
            while (i < functionList.getLength()) {
                Node func = functionList.item(i);
                NodeList child = func.getChildNodes();
                String cname = null;
                String desc = null;
                FunctionPrototypeSummaryImpl prototypeSummary = null;
                int j = 0;
                while (j < child.getLength()) {
                    Node sub = child.item(j);
                    if (sub.getNodeName().equals("cname")) {
                        cname = sub.getFirstChild().getNodeValue();
                    } else if (sub.getNodeName().equals("description")) {
                        desc = sub.getFirstChild().getNodeValue();
                    } else if (sub.getNodeName().equals("prototype")) {
                        NodeList protoSub = sub.getChildNodes();
                        prototypeSummary = new FunctionPrototypeSummaryImpl(protoSub.item(3).getFirstChild().getNodeValue(), protoSub.item(1).getFirstChild().getNodeValue(), protoSub.item(5).getFirstChild().getNodeValue());
                    }
                    ++j;
                }
                FunctionSummaryImpl functionSummary = new FunctionSummaryImpl(cname, "", desc, prototypeSummary, null);
                mpiFuncList.add(functionSummary);
                ++i;
            }
        }
        return mpiFuncList;
    }
}

