/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.actions;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractRemoveMarkerAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private String markerID;
    private String description;
    private boolean doProvideMessageConfirmation = true;

    public AbstractRemoveMarkerAction(String markerID, String description) {
        this(markerID, description, false);
    }

    public AbstractRemoveMarkerAction(String markerID, String description, boolean doProvideMessageConfirmation) {
        this.markerID = markerID;
        this.doProvideMessageConfirmation = doProvideMessageConfirmation;
    }

    public void run(IAction action) {
        this.removeMarkers();
    }

    public void removeMarkers() {
        IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
        int numMarkers = 0;
        try {
            int depth = 2;
            IMarker[] all = wsResource.findMarkers(this.markerID, false, depth);
            numMarkers = all.length;
            wsResource.deleteMarkers(this.markerID, false, depth);
        }
        catch (CoreException e) {
            System.out.println("RM: exception deleting markers.");
            e.printStackTrace();
        }
        if (this.doProvideMessageConfirmation) {
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)(String.valueOf(this.description) + " Artifacts cleared"), (String)(String.valueOf(numMarkers) + " " + this.description + " Artifact" + this.sIfMult(numMarkers) + "have been removed.\n" + "\n"));
        }
    }

    private String sIfMult(int num) {
        if (num != 1) {
            return "s";
        }
        return "";
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

