/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.ControlSystemChoices;
import org.eclipse.ptp.core.IDGenerator;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.core.MonitoringSystemChoices;
import org.eclipse.ptp.internal.core.ModelManager;
import org.eclipse.ptp.internal.rmsystem.ModelManagerResourceManager;
import org.eclipse.ptp.internal.rmsystem.NullResourceManager;
import org.eclipse.ptp.internal.rmsystem.NullResourceManagerFactory;
import org.eclipse.ptp.internal.rmsystem.ResourceManagerPersistence;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerFactory;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerChangedListener;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PTPCorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.core";
    private static final NullResourceManager NULL_RESOURCE_MANAGER = new NullResourceManager();
    private static PTPCorePlugin plugin;
    private ResourceBundle resourceBundle;
    private IDGenerator IDGen;
    private IResourceManagerFactory[] resourceManagerFactories;
    private IResourceManager[] resourceManagers = new IResourceManager[0];
    private IResourceManager currentResourceManager = NULL_RESOURCE_MANAGER;
    private final ListenerList listeners = new ListenerList();

    public static void errorDialog(Shell shell, String title, IStatus s) {
        PTPCorePlugin.errorDialog(shell, title, s.getMessage(), s);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
        } else {
            status = new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Error within PTP Core: ", t);
            PTPCorePlugin.log(status);
        }
        PTPCorePlugin.errorDialog(shell, title, message, status);
    }

    public static void errorDialog(final String title, final String message, final Throwable t) {
        PTPCorePlugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                PTPCorePlugin.errorDialog(PTPCorePlugin.getDisplay().getActiveShell(), title, message, t);
            }
        });
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPCorePlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPCorePlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PTPCorePlugin getDefault() {
        return plugin;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getUniqueIdentifier() {
        if (PTPCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void informationDialog(final String title, final String message) {
        PTPCorePlugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)PTPCorePlugin.getDisplay().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public static void log(IStatus status) {
        PTPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Internal Error", e));
    }

    public static void warningDialog(final String title, final String message) {
        PTPCorePlugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)PTPCorePlugin.getDisplay().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public PTPCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.core.ParallelPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.IDGen = new IDGenerator();
    }

    public synchronized void addResourceManager(IResourceManager addedManager) {
        HashSet<IResourceManager> rms = new HashSet<IResourceManager>((Collection)Arrays.asList(this.resourceManagers));
        rms.add(addedManager);
        this.resourceManagers = rms.toArray(new IResourceManager[rms.size()]);
        this.fireResourceManagersAddedRemoved();
    }

    public void addResourceManagerChangedListener(IResourceManagerChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public IResourceManager getCurrentResourceManager() {
        return this.currentResourceManager;
    }

    public IModelManager getModelManager() {
        return this.getCurrentResourceManager().getModelManager();
    }

    public IModelPresentation getModelPresentation() {
        return this.currentResourceManager.getModelPresentation();
    }

    public synchronized int getNewID() {
        return this.IDGen.getNewID();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public IResourceManagerFactory[] getResourceManagerFactories() {
        if (this.resourceManagerFactories != null) {
            return this.resourceManagerFactories;
        }
        System.out.println("In getResourceManagerFactories");
        ArrayList<AbstractResourceManagerFactory> factoryList = new ArrayList<AbstractResourceManagerFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.core.resourcemanager");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractResourceManagerFactory factory = (AbstractResourceManagerFactory)ce.createExecutableExtension("class");
                    factory.setId(ce.getAttribute("id"));
                    factoryList.add(factory);
                    System.out.println("retrieved factory: " + factory.getName() + ", " + factory.getId());
                }
                catch (CoreException e) {
                    PTPCorePlugin.log(e);
                }
                ++i;
            }
            ++iext;
        }
        this.resourceManagerFactories = factoryList.toArray(new IResourceManagerFactory[factoryList.size()]);
        System.out.println("leaving getResourceManagerFactories");
        return this.resourceManagerFactories;
    }

    public IResourceManagerFactory getResourceManagerFactory(String id) {
        IResourceManagerFactory[] factories = this.getResourceManagerFactories();
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getId().equals(id)) {
                return factories[i];
            }
            ++i;
        }
        return new NullResourceManagerFactory();
    }

    public synchronized IResourceManager[] getResourceManagers() {
        return this.resourceManagers;
    }

    public String locateFragmentFile(String fragment, String file) {
        Bundle[] frags = Platform.getFragments((Bundle)Platform.getBundle((String)PLUGIN_ID));
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        String frag_os_arch = String.valueOf(fragment) + "." + os + "." + arch;
        System.out.println("OS = '" + os + "', Architecture = '" + arch + "', OS_ARCH combo = '" + frag_os_arch + "'");
        String ptp_version = (String)PTPCorePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
        System.out.println("PTP Version = " + ptp_version);
        System.out.println("All Found Fragments:");
        int i = 0;
        while (i < frags.length) {
            System.out.println("\t" + frags[i].toString());
            ++i;
        }
        i = 0;
        while (i < frags.length) {
            Bundle frag = frags[i];
            URL path = frag.getEntry("/");
            try {
                URL local_path = FileLocator.toFileURL((URL)path);
                String str_path = local_path.getPath();
                System.out.println("Testing fragment " + (i + 1) + " with this OS/arch - path: '" + str_path + "'");
                int idx = str_path.indexOf(frag_os_arch);
                if (idx > 0) {
                    System.out.println("\tCorrect fragment for our OS & arch");
                    String file_path = String.valueOf(str_path) + "bin/" + file;
                    System.out.println("\tSearching for file in '" + file_path + "'");
                    File f = new File(file_path);
                    if (f.exists()) {
                        System.out.println("\t\t**** FOUND IT!");
                        return file_path;
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return null;
    }

    public void refreshParallelPluginActions() {
        this.refreshPluginActions();
    }

    public synchronized void removeResourceManager(IResourceManager removedManager) {
        this.removeResourceManagers(new IResourceManager[]{removedManager});
    }

    public void removeResourceManagerChangedListener(IResourceManagerChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void removeResourceManagers(IResourceManager[] removedRMs) {
        HashSet rms = new HashSet(Arrays.asList(this.resourceManagers));
        rms.removeAll((Collection)Arrays.asList(removedRMs));
        this.resourceManagers = rms.toArray(new IResourceManager[rms.size()]);
        if (!rms.contains(this.currentResourceManager)) {
            this.setCurrentResourceManager(this.getDefaultResourceManager());
        }
        this.fireResourceManagersAddedRemoved();
    }

    public synchronized void setCurrentResourceManager(IResourceManager rmManager) {
        IResourceManager oldRmManager = this.currentResourceManager;
        this.currentResourceManager = rmManager != null ? rmManager : NULL_RESOURCE_MANAGER;
        this.fireCurrentResourceManagerChanged(oldRmManager, this.currentResourceManager);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.resourceManagerFactories = this.getResourceManagerFactories();
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        int MSChoiceID = preferences.getInt("MONITORING_SYSTEM_SELECTION");
        String MSChoice = MonitoringSystemChoices.getMSNameByID(MSChoiceID);
        int CSChoiceID = preferences.getInt("CONTROL_SYSTEM_SELECTION");
        String CSChoice = ControlSystemChoices.getCSNameByID(CSChoiceID);
        System.out.println("Your Control System Choice: '" + CSChoice + "'");
        System.out.println("Your Monitoring System Choice: '" + MSChoice + "'");
        if (ControlSystemChoices.getCSArrayIndexByID(CSChoiceID) == -1 || MonitoringSystemChoices.getMSArrayIndexByID(MSChoiceID) == -1) {
            MSChoiceID = 101;
            CSChoiceID = 101;
            System.err.println("No previous (or invalid) control or monitoring system selected.\n\nDefault systems set to Open Runtime Environment (ORTE).  To change, use the Window->Preferences->PTP preferences page.");
            MSChoice = MonitoringSystemChoices.getMSNameByID(MSChoiceID);
            CSChoice = ControlSystemChoices.getCSNameByID(CSChoiceID);
            System.out.println("Your Default Control System Choice: '" + CSChoice + "'");
            System.out.println("Your Default Monitoring System Choice: '" + MSChoice + "'");
        }
        final ModelManager modelManager = new ModelManager(MSChoiceID, CSChoiceID);
        this.setCurrentResourceManager(new ModelManagerResourceManager(modelManager, new IResourceManagerConfiguration(){

            public String getDescription() {
                return Integer.toString(modelManager.getMonitoringSystemID());
            }

            public String getName() {
                return Integer.toString(modelManager.getMonitoringSystemID());
            }

            public String getResourceManagerId() {
                return Integer.toString(modelManager.getMonitoringSystemID());
            }

            public void save(IMemento memento) {
            }

            public void setDefaultNameAndDesc() {
            }

            public void setDescription(String description) {
            }

            public void setName(String name) {
            }
        }));
    }

    public void stop(BundleContext context) throws Exception {
        this.currentResourceManager.stop();
        this.listeners.clear();
        super.stop(context);
    }

    private void fireCurrentResourceManagerChanged(IResourceManager oldRmManager, IResourceManager newRmManager) {
        Object[] tmpListeners = this.listeners.getListeners();
        int i = 0;
        int n = tmpListeners.length;
        while (i < n) {
            IResourceManagerChangedListener listener = (IResourceManagerChangedListener)tmpListeners[i];
            listener.handleCurrentResourceManagerChanged(oldRmManager, newRmManager);
            ++i;
        }
    }

    private void fireResourceManagersAddedRemoved() {
        Object[] tmpListeners = this.listeners.getListeners();
        int i = 0;
        int n = tmpListeners.length;
        while (i < n) {
            IResourceManagerChangedListener listener = (IResourceManagerChangedListener)tmpListeners[i];
            listener.handleResourceManagersAddedRemoved();
            ++i;
        }
    }

    private IResourceManager getDefaultResourceManager() {
        return NULL_RESOURCE_MANAGER;
    }

    private File getResourceManagersFile() {
        return this.getStateLocation().append("resourceManagers.xml").toFile();
    }

    private void loadResourceManagers() {
        ResourceManagerPersistence rmp = new ResourceManagerPersistence();
        rmp.loadResourceManagers(this.getResourceManagersFile(), this.getResourceManagerFactories());
        this.resourceManagers = rmp.getResourceManagers();
        this.setCurrentResourceManager(rmp.getSavedCurrentResourceManager());
    }

    private void saveResourceManagers() {
        ResourceManagerPersistence.saveResourceManagers(this.getResourceManagersFile(), this.resourceManagers, this.currentResourceManager);
    }

    private void stopResourceManagers() throws CoreException {
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].stop();
            ++i;
        }
    }
}

