/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;

public final class IntegerAttribute
extends AbstractAttribute {
    private final Integer value;

    public IntegerAttribute(IAttributeDescription description, int value) {
        super(description);
        this.value = value;
    }

    public IntegerAttribute(IAttributeDescription description, String string) throws IAttribute.IllegalValue {
        super(description);
        try {
            this.value = Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IAttribute.IllegalValue(e);
        }
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        return new IntegerAttribute(this.getDescription(), string);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerAttribute) {
            IntegerAttribute attr = (IntegerAttribute)obj;
            return this.value.equals(attr.value);
        }
        return false;
    }

    public String getStringRep() {
        return this.value.toString();
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    protected int doCompareTo(AbstractAttribute arg0) {
        IntegerAttribute attr = (IntegerAttribute)arg0;
        return this.value.compareTo(attr.value);
    }
}

