/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;
import org.eclipse.ptp.core.attributes.IMutableAttribute;

public final class MutableStringAttribute
extends AbstractAttribute
implements IMutableAttribute {
    private StringBuffer value;

    public MutableStringAttribute(IAttributeDescription description, String string) {
        this(description, new StringBuffer(string));
    }

    public MutableStringAttribute(IAttributeDescription description, StringBuffer value) {
        super(description);
        this.value = value;
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        return new MutableStringAttribute(this.getDescription(), string);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableStringAttribute) {
            MutableStringAttribute attr = (MutableStringAttribute)obj;
            return this.value.equals(attr.value);
        }
        return false;
    }

    public String getStringRep() {
        return this.value.toString();
    }

    public String getValue() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean isValid(String string) {
        return true;
    }

    public void setValue(String string) throws IAttribute.IllegalValue {
        this.value.replace(0, this.value.length(), string);
    }

    protected int doCompareTo(AbstractAttribute arg0) {
        MutableStringAttribute attr = (MutableStringAttribute)arg0;
        return this.value.toString().compareTo(attr.value.toString());
    }
}

