/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.proxy.event;

import org.eclipse.ptp.core.proxy.event.AbstractProxyEvent;
import org.eclipse.ptp.core.proxy.event.IProxyEvent;
import org.eclipse.ptp.core.proxy.event.ProxyConnectedEvent;
import org.eclipse.ptp.core.proxy.event.ProxyErrorEvent;
import org.eclipse.ptp.core.proxy.event.ProxyOKEvent;
import org.eclipse.ptp.core.util.BitList;

public class ProxyEvent {
    private static String join(int start, String[] strs, String delim) {
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < strs.length) {
            if (i > start) {
                buf.append(delim);
            }
            buf.append(strs[i]);
            ++i;
        }
        return buf.toString();
    }

    public static IProxyEvent toEvent(String str) {
        AbstractProxyEvent evt = null;
        String[] args = str.split(" ");
        int type = Integer.parseInt(args[0]);
        switch (type) {
            case 0: {
                evt = new ProxyOKEvent(ProxyEvent.join(1, args, " "));
                break;
            }
            case 1: {
                int errCode = Integer.parseInt(args[1]);
                evt = new ProxyErrorEvent(errCode, ProxyEvent.decodeString(args[2]));
                break;
            }
            case 2: {
                evt = new ProxyConnectedEvent();
                break;
            }
            default: {
                evt = new ProxyErrorEvent(11, "Invalid event type");
            }
        }
        return evt;
    }

    public static String decodeString(String str) {
        String[] parts = str.split(":");
        int len = Integer.parseInt(parts[0], 16) - 1;
        return new String(ProxyEvent.decodeBytes(parts, len));
    }

    public static byte[] decodeBytes(String str) {
        String[] parts = str.split(":");
        int len = Integer.parseInt(parts[0], 16);
        return ProxyEvent.decodeBytes(parts, len);
    }

    private static byte[] decodeBytes(String[] parts, int len) {
        byte[] strBytes = new byte[len];
        int i = 0;
        int p = 0;
        while (i < len) {
            byte c = (byte)((Character.digit(parts[1].charAt(p), 16) & 0xF) << 4);
            strBytes[i] = c = (byte)(c | (byte)(Character.digit(parts[1].charAt(p + 1), 16) & 0xF));
            ++i;
            p += 2;
        }
        return strBytes;
    }

    public static BitList decodeBitSet(String str) {
        String[] parts = str.split(":");
        int len = Integer.parseInt(parts[0], 16);
        return new BitList(len, parts[1]);
    }
}

