/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.mpich2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rtsystem.IControlSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;
import org.eclipse.ptp.rtsystem.event.IRuntimeEvent;
import org.eclipse.ptp.rtsystem.event.RuntimeErrorEvent;
import org.eclipse.ptp.rtsystem.event.RuntimeJobStateChangedEvent;
import org.eclipse.ptp.rtsystem.event.RuntimeProcessOutputEvent;
import org.eclipse.ptp.rtsystem.mpich2.MPICH2ProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEventListener;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeDisconnectedEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeErrorEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeJobStateEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeProcessOutputEvent;

public class MPICH2ControlSystem
implements IControlSystem,
IProxyRuntimeEventListener {
    private Vector knownJobs = null;
    protected List listeners = new ArrayList(2);
    private MPICH2ProxyRuntimeClient proxy = null;
    private boolean proxyDead = true;

    public MPICH2ControlSystem(MPICH2ProxyRuntimeClient proxy) {
        this.proxy = proxy;
        if (proxy != null) {
            this.proxyDead = false;
        }
    }

    public boolean isHealthy() {
        return !this.proxyDead;
    }

    public void startup() {
        this.knownJobs = new Vector();
        this.proxy.addRuntimeEventListener(this);
    }

    public void run(int jobID, JobRunConfiguration jobRunConfig) throws CoreException {
        String[] env;
        String[] args;
        System.out.println("JAVA MPICH2: run() with args:\n" + jobRunConfig.toString());
        if (this.proxyDead) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Control system is shut down", null));
        }
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("jobID");
        argList.add(Integer.toString(jobID));
        argList.add("execName");
        argList.add(jobRunConfig.getExecName());
        String path = jobRunConfig.getPathToExec();
        if (path != null) {
            argList.add("pathToExec");
            argList.add(path);
        }
        argList.add("numOfProcs");
        argList.add(Integer.toString(jobRunConfig.getNumberOfProcesses()));
        argList.add("procsPerNode");
        argList.add(Integer.toString(jobRunConfig.getNumberOfProcessesPerNode()));
        argList.add("firstNodeNum");
        argList.add(Integer.toString(jobRunConfig.getFirstNodeNumber()));
        String dir = jobRunConfig.getWorkingDir();
        if (dir != null) {
            argList.add("workingDir");
            argList.add(dir);
        }
        if ((args = jobRunConfig.getArguments()) != null) {
            int i = 0;
            while (i < args.length) {
                argList.add("progArg");
                argList.add(args[i]);
                ++i;
            }
        }
        if ((env = jobRunConfig.getEnvironment()) != null) {
            int i = 0;
            while (i < env.length) {
                argList.add("progEnv");
                argList.add(env[i]);
                ++i;
            }
        }
        if (jobRunConfig.isDebug()) {
            argList.add("debuggerPath");
            argList.add(jobRunConfig.getDebuggerPath());
            String[] dbgArgs = jobRunConfig.getDebuggerArgs();
            if (dbgArgs != null) {
                int i = 0;
                while (i < dbgArgs.length) {
                    argList.add("debuggerArg");
                    argList.add(dbgArgs[i]);
                    ++i;
                }
            }
        }
        try {
            this.proxy.runJob(argList.toArray(new String[0]));
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Control system is shut down, proxy exception.  The proxy may have crashed or been killed.", null));
        }
    }

    public void terminateJob(IPJob job) throws CoreException {
        if (this.proxyDead) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Control system is shut down", null));
        }
        if (job == null) {
            System.err.println("ERROR: Tried to abort a null job.");
            return;
        }
        int jobID = job.getJobNumberInt();
        if (jobID >= 0) {
            System.out.println("MPICH2ControlSystem: abortJob() with name " + job.toString() + " and ID " + jobID);
            try {
                this.proxy.terminateJob(jobID);
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Control system is shut down, proxy exception.  The proxy may have crashed or been killed.", null));
            }
        } else {
            System.err.println("ERROR: Tried to abort a null job.");
        }
    }

    public String[] getJobs() throws CoreException {
        if (this.proxyDead) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Control system is shut down", null));
        }
        if (this.knownJobs == null) {
            System.out.println("NULL JOBS!");
            return null;
        }
        Object[] a = this.knownJobs.toArray();
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return null;
        }
        return (String[])a;
    }

    public void addRuntimeListener(IRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRuntimeListener(IRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireEvent(IRuntimeEvent event) {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IRuntimeListener)i.next()).performRuntimeEvent(event);
        }
    }

    public void shutdown() {
        System.out.println("MPICH2ControlSystem: shutdown() called");
        this.listeners.clear();
        this.listeners = null;
    }

    public synchronized void handleEvent(IProxyRuntimeEvent e) {
        if (e instanceof ProxyRuntimeJobStateEvent) {
            int state = ((ProxyRuntimeJobStateEvent)e).getJobState();
            String stateStr = "error";
            switch (state) {
                case 1: {
                    stateStr = "starting";
                    break;
                }
                case 2: {
                    stateStr = "running";
                    break;
                }
                case 3: {
                    stateStr = "exited";
                    break;
                }
                case 4: {
                    stateStr = "error";
                    break;
                }
                default: {
                    stateStr = "error";
                }
            }
            this.fireEvent(new RuntimeJobStateChangedEvent("job" + ((ProxyRuntimeJobStateEvent)e).getJobID(), stateStr));
        } else if (e instanceof ProxyRuntimeProcessOutputEvent) {
            int jobID = ((ProxyRuntimeProcessOutputEvent)e).getJobID();
            int procID = ((ProxyRuntimeProcessOutputEvent)e).getProcessID();
            String text = ((ProxyRuntimeProcessOutputEvent)e).getText();
            this.fireEvent(new RuntimeProcessOutputEvent("job" + jobID + "_process" + procID, text));
        } else if (e instanceof ProxyRuntimeErrorEvent) {
            System.err.println("Fatal error from proxy: '" + ((ProxyRuntimeErrorEvent)e).getErrorMessage() + "'");
            int errorCode = ((ProxyRuntimeErrorEvent)e).getErrorCode();
            String errorMsg = ((ProxyRuntimeErrorEvent)e).getErrorMessage();
            this.proxyDead = true;
            this.fireEvent(new RuntimeErrorEvent(errorMsg, errorCode));
        } else if (e instanceof ProxyRuntimeDisconnectedEvent) {
            boolean is_error = ((ProxyRuntimeDisconnectedEvent)e).wasError();
            System.out.println("Proxy Disconnected.");
            this.proxyDead = true;
            if (is_error) {
                PTPCorePlugin.errorDialog("Fatal PTP Control System Error", "There was a fatal PTP Control System error.  The proxy server disconnected with an error.\n\nControl System is now disabled.", null);
            }
        }
    }
}

