/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.mpich2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.BitSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.util.Queue;
import org.eclipse.ptp.rtsystem.IRuntimeProxy;
import org.eclipse.ptp.rtsystem.proxy.ProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEventListener;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeDisconnectedEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeErrorEvent;

public class MPICH2ProxyRuntimeClient
extends ProxyRuntimeClient
implements IRuntimeProxy,
IProxyRuntimeEventListener {
    protected Queue events = new Queue();
    protected BitSet waitEvents = new BitSet();
    protected IModelManager modelManager;

    public MPICH2ProxyRuntimeClient(IModelManager modelManager) {
        super.addRuntimeEventListener(this);
        this.modelManager = modelManager;
    }

    public void runJob(String[] args) throws IOException {
        this.run(args);
    }

    public boolean startup(final IProgressMonitor monitor) {
        System.out.println("MPICH2ProxyRuntimeClient - firing up proxy, waiting for connecting.  Please wait!  This can take a minute . . .");
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        String proxyPath = preferences.getString("MPICH2_PROXY_PATH");
        System.out.println("MPICH2_SERVER path = '" + proxyPath + "'");
        if (proxyPath.equals("")) {
            proxyPath = PTPCorePlugin.getDefault().locateFragmentFile("org.eclipse.ptp.mpich2.proxy", "ptp_mpich2_proxy.py");
            if (proxyPath != null) {
                preferences.setValue("MPICH2_PROXY_PATH", proxyPath);
            } else {
                String err = "Could not find the MPICH2 server ('ptp_mpich2_proxy').  File not found in the fragment directory or developer directories.  Defaulting to Simulation Mode.";
                System.err.println(err);
                int MSI = 100;
                int CSI = 100;
                preferences.setValue("MONITORING_SYSTEM_SELECTION", MSI);
                preferences.setValue("CONTROL_SYSTEM_SELECTION", CSI);
                PTPCorePlugin.getDefault().savePluginPreferences();
                return false;
            }
        }
        final String proxyPath2 = preferences.getString("MPICH2_PROXY_PATH");
        try {
            this.setWaitEvent(210);
            this.sessionCreate();
            if (preferences.getBoolean("MPICH2_LAUNCH_MANUALLY")) {
                monitor.subTask("Waiting for manual lauch of ptp_mpich2_proxy on port " + this.getSessionPort() + "...");
            } else {
                Thread runThread = new Thread("Proxy Server Thread"){

                    public void run() {
                        block2: {
                            String cmd = String.valueOf(proxyPath2) + " --port=" + MPICH2ProxyRuntimeClient.this.getSessionPort();
                            System.out.println("RUNNING PROXY SERVER COMMAND: '" + cmd + "'");
                            try {
                                Process process = Runtime.getRuntime().exec(cmd);
                                final BufferedReader err_reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                                final BufferedReader out_reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                new Thread(new Runnable(){

                                    public void run() {
                                        try {
                                            String output;
                                            while ((output = out_reader.readLine()) != null) {
                                                System.out.println("++++++++++ ptp_orte_proxy: " + output);
                                            }
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }, "Program output Thread").start();
                                new Thread(new Runnable(){

                                    public void run() {
                                        try {
                                            String line;
                                            while ((line = err_reader.readLine()) != null) {
                                                PTPCorePlugin.log(line);
                                            }
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }, "Error output Thread").start();
                            }
                            catch (IOException e) {
                                PTPCorePlugin.errorDialog("Running Proxy Server", null, e);
                                if (monitor == null) break block2;
                                monitor.setCanceled(true);
                            }
                        }
                    }
                };
                runThread.setDaemon(true);
                runThread.start();
            }
            System.out.println("Waiting on accept.");
            this.waitForRuntimeEvent(monitor);
            this.setWaitEvent(200);
            this.setWaitEvent(211);
            this.sendCommand("STARTDAEMON");
            this.waitForRuntimeEvent();
        }
        catch (IOException iOException) {
            System.err.println("Exception starting up proxy. :(");
            try {
                this.sessionFinish();
            }
            catch (IOException e1) {
                PTPCorePlugin.log(e1);
            }
            return false;
        }
        return true;
    }

    public void shutdown() {
        try {
            System.out.println("MPICH2ProxyRuntimeClient shutting down server...");
            this.setWaitEvent(200);
            this.sessionFinish();
            this.waitForRuntimeEvent();
            System.out.println("MPICH2ProxyRuntimeClient shut down.");
        }
        catch (IOException e) {
            PTPCorePlugin.log(e);
        }
    }

    private void setWaitEvent(int eventID) {
        this.waitEvents.set(eventID);
        this.waitEvents.set(201);
    }

    private IProxyRuntimeEvent waitForRuntimeEvent() throws IOException {
        return this.waitForRuntimeEvent(null);
    }

    private synchronized IProxyRuntimeEvent waitForRuntimeEvent(IProgressMonitor monitor) throws IOException {
        IProxyRuntimeEvent event = null;
        System.out.println("MPICH2ProxyRuntimeClient waiting on " + this.waitEvents.toString());
        while (this.events.isEmpty()) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Interrupted exception.");
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            throw new IOException("Cancelled by user");
        }
        System.out.println("MPICH2ProxyRuntimeClient awoke!");
        try {
            event = (IProxyRuntimeEvent)this.events.removeItem();
        }
        catch (InterruptedException e) {
            this.waitEvents.clear();
            throw new IOException(e.getMessage());
        }
        this.waitEvents.clear();
        if (event instanceof ProxyRuntimeErrorEvent) {
            throw new IOException(((ProxyRuntimeErrorEvent)event).getErrorMessage());
        }
        if (event instanceof ProxyRuntimeDisconnectedEvent && ((ProxyRuntimeDisconnectedEvent)event).wasError()) {
            throw new IOException("Connection to proxy server unexpectedly broken.");
        }
        return event;
    }

    public synchronized void handleEvent(IProxyRuntimeEvent e) {
        System.out.println("MPICH2ProxyRuntimeClient got event: " + e.toString());
        if (this.waitEvents.get(e.getEventID())) {
            System.out.println("MPICH2ProxyRuntimeClient notifying...");
            this.events.addItem(e);
            this.notifyAll();
        }
    }
}

