/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.ompi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rtsystem.IMonitoringSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.event.IRuntimeEvent;
import org.eclipse.ptp.rtsystem.event.RuntimeNodeGeneralChangedEvent;
import org.eclipse.ptp.rtsystem.ompi.OMPIProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEventListener;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeErrorEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNodeAttributeEvent;

public class OMPIMonitoringSystem
implements IMonitoringSystem,
IProxyRuntimeEventListener {
    protected List listeners = new ArrayList(2);
    private OMPIProxyRuntimeClient proxy = null;
    private boolean proxyDead = true;

    public boolean isHealthy() {
        return !this.proxyDead;
    }

    public OMPIMonitoringSystem(OMPIProxyRuntimeClient proxy) {
        this.proxy = proxy;
        if (proxy != null) {
            this.proxyDead = false;
        }
        proxy.addRuntimeEventListener(this);
    }

    public void addRuntimeListener(IRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRuntimeListener(IRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    public void startup() {
        System.out.println("OMPIMonitoringSystem startup()");
    }

    public void shutdown() {
        System.out.println("OMPIMonitoringSystem shutdown()");
        this.listeners.clear();
        this.listeners = null;
    }

    public void initiateDiscovery() throws CoreException {
        if (this.proxyDead) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Monitoring system is shut down", null));
        }
        System.out.println("OMPIMonitoringSystem: initiateDiscovery phase");
        try {
            this.proxy.initiateDiscovery();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Proxy IO Exception", null));
        }
    }

    public synchronized void handleEvent(IProxyRuntimeEvent e) {
        if (e instanceof ProxyRuntimeNodeAttributeEvent) {
            String[] keys = ((ProxyRuntimeNodeAttributeEvent)e).getKeys();
            String[] vals = ((ProxyRuntimeNodeAttributeEvent)e).getValues();
            this.fireEvent(new RuntimeNodeGeneralChangedEvent(keys, vals));
        } else if (e instanceof ProxyRuntimeErrorEvent) {
            System.err.println("Fatal error from proxy: '" + ((ProxyRuntimeErrorEvent)e).getErrorMessage() + "'");
            ((ProxyRuntimeErrorEvent)e).getErrorCode();
            ((ProxyRuntimeErrorEvent)e).getErrorMessage();
            this.proxyDead = true;
        }
    }

    protected synchronized void fireEvent(IRuntimeEvent event) {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IRuntimeListener)i.next()).performRuntimeEvent(event);
        }
    }
}

