/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.eclipse.ptp.rtsystem.simulation.SimProcess;
import org.eclipse.ptp.rtsystem.simulation.SimStackFrame;

public class SimThread
extends Observable {
    final int RUNNING = 10;
    final int SUSPENDED = 11;
    final int TERMINATED = 12;
    boolean isStepping = false;
    int state = 10;
    int currentNumStackFrames;
    SimStackFrame currentStackFrame;
    int curLine = 1;
    ArrayList breakLines;
    ArrayList stackFrameList;
    int threadId;
    int processId;
    SimProcess simProcess;

    public SimThread(SimProcess proc, int tid, int pId) {
        this.simProcess = proc;
        this.breakLines = new ArrayList();
        this.threadId = tid;
        this.processId = pId;
        int numStackFrames = 5;
        this.stackFrameList = new ArrayList();
        int i = 0;
        while (i < numStackFrames) {
            SimStackFrame sF = new SimStackFrame(i + 1, "123456", "main", "main.c", 0);
            this.stackFrameList.add(sF);
            ++i;
        }
        this.currentNumStackFrames = 1;
        this.currentStackFrame = (SimStackFrame)this.stackFrameList.get(this.currentNumStackFrames - 1);
    }

    public int getThreadId() {
        return this.threadId;
    }

    public int getStackFrameCount() {
        return this.currentNumStackFrames;
    }

    public SimStackFrame[] getStackFrames() {
        List list = this.stackFrameList.subList(0, this.currentNumStackFrames);
        ArrayList newList = new ArrayList(list);
        if (this.currentNumStackFrames > 1) {
            Collections.reverse(newList);
        }
        return newList.toArray(new SimStackFrame[0]);
    }

    public void runCommand(String cmd, String arg) {
        if (cmd.equals("print")) {
            this.simProcess.addOutput(String.valueOf(this.curLine) + " : " + arg + " from process with task id: " + this.processId + " & thread #" + this.threadId);
            ++this.curLine;
        }
        this.checkStepping();
        this.checkBreakpoint();
    }

    public void addBreakpoint(int line) {
        this.breakLines.add(new Integer(line));
    }

    public void checkStepping() {
        if (this.isStepping) {
            this.state = 11;
            this.simProcess.setStatus("stopped");
            this.setChanged();
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(0, new Integer(this.processId));
            list.add(1, new String("ENDSTEPPINGRANGE"));
            list.add(2, new String("main.c"));
            list.add(3, new Integer(this.curLine));
            this.currentStackFrame.setLine(this.curLine);
            this.notifyObservers(list);
            return;
        }
    }

    public void checkBreakpoint() {
        Integer[] bps = this.breakLines.toArray(new Integer[0]);
        int i = 0;
        while (i < bps.length) {
            if (this.curLine == bps[i]) {
                this.state = 11;
                this.simProcess.setStatus("stopped");
                this.setChanged();
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(0, new Integer(this.processId));
                list.add(1, new String("BREAKPOINTHIT"));
                list.add(2, new String("main.c"));
                list.add(3, new Integer(this.curLine));
                this.currentStackFrame.setLine(this.curLine);
                this.notifyObservers(list);
                return;
            }
            ++i;
        }
    }

    public void suspend() {
        this.state = 11;
        this.simProcess.setStatus("stopped");
        this.setChanged();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(0, new Integer(this.processId));
        list.add(1, new String("SUSPENDED"));
        list.add(2, new String("main.c"));
        list.add(3, new Integer(this.curLine));
        this.currentStackFrame.setLine(this.curLine);
        this.notifyObservers(list);
    }

    public void terminate() {
        this.state = 12;
        this.simProcess.setStatus("exited");
        this.setChanged();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(0, new Integer(this.processId));
        list.add(1, new String("TERMINATED"));
        this.notifyObservers(list);
    }

    public void resume() {
        this.isStepping = false;
        this.state = 10;
        this.simProcess.setStatus("running");
        this.setChanged();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(0, new Integer(this.processId));
        list.add(1, new String("RESUMED"));
        this.notifyObservers(list);
    }

    public void stepOver(int count) {
        this.isStepping = true;
        this.state = 10;
        this.simProcess.setStatus("running");
        this.setChanged();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(0, new Integer(this.processId));
        list.add(1, new String("RESUMED"));
        this.notifyObservers(list);
    }

    public void stepInto(int count) {
        ++this.currentNumStackFrames;
        this.currentStackFrame = (SimStackFrame)this.stackFrameList.get(this.currentNumStackFrames - 1);
        this.isStepping = true;
        this.state = 10;
        this.simProcess.setStatus("running");
        this.setChanged();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(0, new Integer(this.processId));
        list.add(1, new String("RESUMED"));
        this.notifyObservers(list);
    }

    public void stepFinish(int count) {
        --this.currentNumStackFrames;
        this.currentStackFrame = (SimStackFrame)this.stackFrameList.get(this.currentNumStackFrames - 1);
        this.isStepping = true;
        this.state = 10;
        this.simProcess.setStatus("running");
        this.setChanged();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(0, new Integer(this.processId));
        list.add(1, new String("RESUMED"));
        this.notifyObservers(list);
    }
}

